/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.jmx;

import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.StandardMBean;
import net.java.truecommons.shed.Filter;
import net.java.truecommons.shed.Visitor;
import net.java.truevfs.comp.jmx.CountingVisitor;
import net.java.truevfs.comp.jmx.JmxManagerMXBean;
import net.java.truevfs.comp.jmx.MountedFileSystemsFilter;
import net.java.truevfs.comp.jmx.MountedTopLevelArchiveFileSystemsFilter;
import net.java.truevfs.comp.jmx.TotalTopLevelArchiveFileSystemsFilter;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsSync;
import net.java.truevfs.kernel.spec.FsSyncException;

@ThreadSafe
public class JmxManagerView<M extends FsManager>
extends StandardMBean
implements JmxManagerMXBean {
    protected final M manager;

    public JmxManagerView(M manager) {
        this(manager, JmxManagerMXBean.class);
    }

    protected JmxManagerView(M manager, Class<? extends JmxManagerMXBean> type) {
        super(type, true);
        this.manager = (FsManager)Objects.requireNonNull(manager);
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "A file system manager.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        switch (info.getName()) {
            case "FileSystemsMounted": {
                return "The number of file systems which have been mounted.";
            }
            case "FileSystemsTotal": {
                return "The total number of file systems.";
            }
            case "TopLevelArchiveFileSystemsMounted": {
                return "The number of top level archive file systems which have been mounted.";
            }
            case "TopLevelArchiveFileSystemsTotal": {
                return "The total number of top level archive file systems.";
            }
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        return "sync".equals(info.getName()) ? "Synchronizes all file systems and eventually unmounts them." : null;
    }

    @Override
    public int getFileSystemsTotal() {
        return this.count((Filter<FsController>)Filter.ACCEPT_ANY);
    }

    @Override
    public int getFileSystemsMounted() {
        return this.count(new MountedFileSystemsFilter());
    }

    @Override
    public int getTopLevelArchiveFileSystemsTotal() {
        return this.count(new TotalTopLevelArchiveFileSystemsFilter());
    }

    @Override
    public int getTopLevelArchiveFileSystemsMounted() {
        return this.count(new MountedTopLevelArchiveFileSystemsFilter());
    }

    private int count(Filter<? super FsController> filter) {
        return ((CountingVisitor)this.manager.accept(filter, (Visitor)new CountingVisitor())).get();
    }

    @Override
    public void sync() throws FsSyncException {
        new FsSync().run();
    }
}

