/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TFileInputStream;
import net.java.truevfs.access.TFileOutputStream;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsSyncException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyManagementITSuite {
    private static final Logger logger = LoggerFactory.getLogger(KeyManagementITSuite.class);
    private static final String PREFIX = "tzp";
    private static final String EXTENSION = "eaff";
    private static final String PASSWORD = "top secret";
    private static final byte[] DATA = new byte[1024];
    private byte[] data;
    private File temp;
    private TFile archive;

    @Before
    public void setUp() throws IOException {
        this.data = (byte[])DATA.clone();
        this.temp = KeyManagementITSuite.createTempFile();
        Assert.assertTrue((boolean)this.temp.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws IOException {
        try {
            try {
                this.umount();
            }
            finally {
                File temp = this.temp;
                this.temp = null;
                if (null != temp && temp.exists() && !temp.delete()) {
                    throw new IOException(temp + " (could not delete)");
                }
            }
        }
        catch (IOException ex) {
            logger.trace("Failed to clean up test file (this may be just an aftermath):", (Throwable)ex);
        }
    }

    private static File createTempFile() throws IOException {
        return File.createTempFile(PREFIX, ".eaff").getCanonicalFile();
    }

    private void umount() throws FsSyncException {
        if (null != this.archive) {
            TVFS.umount((TFile)this.archive);
        }
    }

    @Test
    public void testSetPasswords1() throws IOException {
        this.archive = new TFile(this.temp, this.newArchiveDetector1(EXTENSION, PASSWORD));
        this.roundTrip();
    }

    protected abstract TArchiveDetector newArchiveDetector1(String var1, String var2);

    @Test
    public void testSetPasswords2() throws IOException {
        this.archive = new TFile(this.temp, this.newArchiveDetector2(EXTENSION, PASSWORD));
        this.roundTrip();
    }

    protected abstract TArchiveDetector newArchiveDetector2(String var1, String var2);

    private void roundTrip() throws IOException {
        TFile file = new TFile((File)this.archive, "entry");
        try (TFileOutputStream os = new TFileOutputStream((File)file);){
            os.write(this.data);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.data.length);
        try (TFileInputStream is = new TFileInputStream((File)file);){
            TFile.cat((InputStream)is, (OutputStream)baos);
        }
        Arrays.equals(this.data, baos.toByteArray());
    }

    static {
        new Random().nextBytes(DATA);
    }
}

