/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.driver.mock;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Objects;
import javax.annotation.CheckForNull;
import net.java.truevfs.kernel.spec.FsArchiveEntries;
import net.java.truevfs.kernel.spec.FsArchiveEntry;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.IoBuffer;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;

public final class MockArchiveDriverEntry
implements FsArchiveEntry {
    private final String name;
    private final Entry.Type type;
    private final EnumMap<Entry.Size, Long> sizes = new EnumMap(Entry.Size.class);
    private final EnumMap<Entry.Access, Long> times = new EnumMap(Entry.Access.class);
    private final Boolean[][] permissions = new Boolean[Entry.Access.values().length][Entry.PosixEntity.values().length];
    @CheckForNull
    private IoBuffer buffer;

    public MockArchiveDriverEntry(String name, Entry.Type type) {
        this(name, type, null);
    }

    public MockArchiveDriverEntry(String name, Entry.Type type, @CheckForNull Entry template) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        if (null != template) {
            long value;
            for (Entry.Size size : ALL_SIZES) {
                value = template.getSize(size);
                if (-1L == value) continue;
                this.sizes.put(size, value);
            }
            for (Entry.Access access : ALL_ACCESS) {
                value = template.getTime(access);
                if (-1L != value) {
                    this.times.put(access, value);
                }
                for (Entry.PosixEntity entity : ALL_POSIX_ENTITIES) {
                    this.permissions[access.ordinal()][entity.ordinal()] = template.isPermitted(access, (Entry.Entity)entity);
                }
            }
        }
    }

    IoBuffer getBuffer(IoBufferPool pool) throws IOException {
        IoBuffer buffer = this.buffer;
        return null != buffer ? buffer : (this.buffer = (IoBuffer)pool.allocate());
    }

    public String getName() {
        return this.name;
    }

    public Entry.Type getType() {
        return this.type;
    }

    public long getSize(Entry.Size type) {
        Long size = this.sizes.get(type);
        return null != size ? size : -1L;
    }

    public boolean setSize(Entry.Size type, long value) {
        this.sizes.put(type, value);
        return true;
    }

    public long getTime(Entry.Access type) {
        Long time = this.times.get(type);
        return null != time ? time : -1L;
    }

    public boolean setTime(Entry.Access type, long value) {
        this.times.put(type, value);
        return true;
    }

    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        if (!(entity instanceof Entry.PosixEntity)) {
            return null;
        }
        return this.permissions[type.ordinal()][((Entry.PosixEntity)entity).ordinal()];
    }

    public boolean setPermitted(Entry.Access type, Entry.Entity entity, Boolean value) {
        if (!(entity instanceof Entry.PosixEntity)) {
            return false;
        }
        this.permissions[type.ordinal()][((Entry.PosixEntity)entity).ordinal()] = value;
        return true;
    }

    public String toString() {
        return FsArchiveEntries.toString((FsArchiveEntry)this);
    }
}

