/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.net.URI;
import java.util.Iterator;
import net.java.truecommons.services.Container;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.Link;
import net.java.truevfs.kernel.driver.mock.MockDriverMapContainer;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsMetaDriver;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsSimpleMetaDriver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FsManagerTestSuite {
    private final FsMetaDriver driver = new FsSimpleMetaDriver((Container)new MockDriverMapContainer("file|zip"));
    private FsManager manager;

    @Before
    public void setUp() {
        this.manager = this.newManager(Link.Type.WEAK);
    }

    protected abstract FsManager newManager(Link.Type var1);

    @Test
    public void testGetControllerWithNull() {
        for (Link.Type type : BitField.allOf(Link.Type.class)) {
            try {
                this.newManager(type).controller(null, null);
                Assert.fail();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test
    public void testForward() throws InterruptedException {
        for (String[] params : new String[][]{{"file:/", "zip:file:/\u00f6uter.zip!/", "zip:zip:file:/\u00f6uter.zip!/inner.zip!/", "zip:zip:zip:file:/\u00f6uter.zip!/inner.zip!/n\u00fcts.zip!/"}, {"file:/", "zip:file:/f\u00f6o.zip!/", "zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/", "zip:zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/b\u00e4z.zip!/"}}) {
            FsController parent = null;
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                FsController controller = this.manager.controller(this.driver, mountPoint);
                if (null != parent && null != parent.getParent()) {
                    Assert.assertThat((Object)controller.getParent(), (Matcher)CoreMatchers.sameInstance((Object)parent));
                }
                parent = controller;
            }
            Assert.assertThat((Object)this.manager.size(), (Matcher)CoreMatchers.is((Object)params.length));
            parent = null;
            this.waitAllManagers();
        }
    }

    @Test
    public void testBackward() throws InterruptedException {
        for (String[] params : new String[][]{{"zip:zip:zip:file:/\u00f6uter.zip!/inner.zip!/n\u00fcts.zip!/", "zip:zip:file:/\u00f6uter.zip!/inner.zip!/", "zip:file:/\u00f6uter.zip!/", "file:/"}, {"zip:zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/b\u00e4z.zip!/", "zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/", "zip:file:/f\u00f6o.zip!/", "file:/"}}) {
            FsController top = null;
            FsController member = null;
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                FsController controller = this.manager.controller(this.driver, mountPoint);
                if (null != member && null != controller.getParent()) {
                    Assert.assertThat((Object)controller, (Matcher)CoreMatchers.sameInstance((Object)member.getParent()));
                }
                member = controller;
                if (null != top) continue;
                top = controller;
            }
            Iterator i = this.manager.iterator();
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                Assert.assertThat((Object)((FsController)i.next()).getModel().getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            }
            Assert.assertThat((Object)i.hasNext(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)this.manager.size(), (Matcher)CoreMatchers.is((Object)params.length));
            member = null;
            i = null;
            top = null;
            this.waitAllManagers();
        }
    }

    private void waitAllManagers() {
        do {
            System.gc();
        } while (0 < this.manager.size());
    }
}

