/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.io;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truevfs.kernel.spec.TestConfig;
import net.java.truevfs.kernel.spec.ThrowManager;

@NotThreadSafe
public final class ThrowingOutputStream
extends DecoratingOutputStream {
    private final ThrowManager control;

    @CreatesObligation
    public ThrowingOutputStream(@WillCloseWhenClosed OutputStream out) {
        this(out, null);
    }

    @CreatesObligation
    public ThrowingOutputStream(@WillCloseWhenClosed OutputStream out, @CheckForNull ThrowManager control) {
        super(out);
        this.control = null != control ? control : TestConfig.get().getThrowControl();
    }

    private void checkAllExceptions() throws IOException {
        this.control.check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.control.check((Object)this, RuntimeException.class);
        this.control.check((Object)this, Error.class);
    }

    public void write(int b) throws IOException {
        this.checkAllExceptions();
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkAllExceptions();
        this.out.write(b, off, len);
    }

    public void flush() throws IOException {
        this.checkAllExceptions();
        this.out.flush();
    }

    public void close() throws IOException {
        this.checkAllExceptions();
        this.out.close();
    }
}

