/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.io;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingSeekableChannel;
import net.java.truevfs.kernel.spec.TestConfig;
import net.java.truevfs.kernel.spec.ThrowManager;

@NotThreadSafe
public final class ThrowingSeekableChannel
extends DecoratingSeekableChannel {
    private final ThrowManager control;

    @CreatesObligation
    public ThrowingSeekableChannel(@WillCloseWhenClosed SeekableByteChannel sbc) {
        this(sbc, null);
    }

    @CreatesObligation
    public ThrowingSeekableChannel(@WillCloseWhenClosed SeekableByteChannel channel, @CheckForNull ThrowManager control) {
        super(channel);
        this.control = null != control ? control : TestConfig.get().getThrowControl();
    }

    private void checkAllExceptions() throws IOException {
        this.control.check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.control.check((Object)this, RuntimeException.class);
        this.control.check((Object)this, Error.class);
    }

    public boolean isOpen() {
        this.checkUndeclaredExceptions();
        return this.channel.isOpen();
    }

    public int read(ByteBuffer dst) throws IOException {
        this.checkAllExceptions();
        return this.channel.read(dst);
    }

    public int write(ByteBuffer src) throws IOException {
        this.checkAllExceptions();
        return this.channel.write(src);
    }

    public long position() throws IOException {
        this.checkAllExceptions();
        return this.channel.position();
    }

    public SeekableByteChannel position(long newPosition) throws IOException {
        this.checkAllExceptions();
        this.channel.position(newPosition);
        return this;
    }

    public long size() throws IOException {
        this.checkAllExceptions();
        return this.channel.size();
    }

    public SeekableByteChannel truncate(long size) throws IOException {
        this.checkAllExceptions();
        this.channel.truncate(size);
        return this;
    }

    public void close() throws IOException {
        this.checkAllExceptions();
        this.channel.close();
    }
}

