/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.sample;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.java.truecommons.services.Container;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsMetaDriver;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsSimpleMetaDriver;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import net.java.truevfs.kernel.spec.FsUriModifier;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoSockets;
import net.java.truevfs.kernel.spec.cio.OutputSocket;
import net.java.truevfs.kernel.spec.sl.FsDriverMapLocator;
import net.java.truevfs.kernel.spec.sl.FsManagerLocator;

public final class Copy {
    private Copy() {
    }

    public static void main(String[] args) throws IOException {
        Copy.copy(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(String src, String dst) throws IOException {
        FsManager manager = FsManagerLocator.SINGLETON.get();
        try {
            FsSimpleMetaDriver driver = new FsSimpleMetaDriver((Container)FsDriverMapLocator.SINGLETON);
            URI srcUri = URI.create(src);
            srcUri = srcUri.isAbsolute() ? srcUri : new File(src).toURI();
            FsNodePath srcPath = FsNodePath.create((URI)srcUri, (FsUriModifier)FsUriModifier.CANONICALIZE);
            InputSocket srcSocket = manager.controller((FsMetaDriver)driver, srcPath.getMountPoint()).input(FsAccessOptions.NONE, srcPath.getNodeName());
            URI dstUri = URI.create(dst);
            dstUri = dstUri.isAbsolute() ? dstUri : new File(dst).toURI();
            FsNodePath dstPath = FsNodePath.create((URI)dstUri, (FsUriModifier)FsUriModifier.CANONICALIZE);
            OutputSocket dstSocket = manager.controller((FsMetaDriver)driver, dstPath.getMountPoint()).output(BitField.of((Enum)FsAccessOption.CREATE_PARENTS, (Enum[])new FsAccessOption[]{FsAccessOption.EXCLUSIVE}), dstPath.getNodeName(), srcSocket.target());
            IoSockets.copy((InputSocket)srcSocket, (OutputSocket)dstSocket);
        }
        finally {
            manager.sync(FsSyncOptions.UMOUNT);
        }
    }
}

