/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.driver.mock;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.kernel.driver.mock.MockArchiveDriverEntry;
import net.java.truevfs.kernel.spec.TestConfig;
import net.java.truevfs.kernel.spec.ThrowManager;
import net.java.truevfs.kernel.spec.cio.AbstractInputSocket;
import net.java.truevfs.kernel.spec.cio.AbstractOutputSocket;
import net.java.truevfs.kernel.spec.cio.Container;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputService;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoBuffer;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;
import net.java.truevfs.kernel.spec.cio.OutputService;
import net.java.truevfs.kernel.spec.cio.OutputSocket;
import net.java.truevfs.kernel.spec.cio.ThrowingInputService;
import net.java.truevfs.kernel.spec.cio.ThrowingOutputService;

@NotThreadSafe
public class MockArchive
implements Container<MockArchiveDriverEntry> {
    final Map<String, MockArchiveDriverEntry> entries;
    private final TestConfig config;
    @CheckForNull
    private ThrowManager control;

    public static MockArchive create(@CheckForNull TestConfig config) {
        if (null == config) {
            config = TestConfig.get();
        }
        return new MockArchive(new LinkedHashMap<String, MockArchiveDriverEntry>(HashMaps.initialCapacity((int)config.getNumEntries())), config);
    }

    private MockArchive(Map<String, MockArchiveDriverEntry> entries, TestConfig config) {
        this.entries = entries;
        this.config = config;
    }

    private ThrowManager getThrowControl() {
        ThrowManager control = this.control;
        return null != control ? control : (this.control = this.config.getThrowControl());
    }

    private void checkUndeclaredExceptions() {
        this.getThrowControl().check(this, RuntimeException.class);
        this.getThrowControl().check(this, Error.class);
    }

    public IoBufferPool getPool() {
        return this.config.getPool();
    }

    public int size() {
        this.checkUndeclaredExceptions();
        return this.entries.size();
    }

    public Iterator<MockArchiveDriverEntry> iterator() {
        this.checkUndeclaredExceptions();
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public MockArchiveDriverEntry entry(String name) {
        this.checkUndeclaredExceptions();
        return this.entries.get(name);
    }

    public InputService<MockArchiveDriverEntry> newInputService() {
        this.checkUndeclaredExceptions();
        return new ThrowingInputService<MockArchiveDriverEntry>(new MockInputService(this.entries, this.config), this.config);
    }

    public OutputService<MockArchiveDriverEntry> newOutputService() {
        this.checkUndeclaredExceptions();
        return new ThrowingOutputService<MockArchiveDriverEntry>(new MockOutputService(this.entries, this.config), this.config);
    }

    private static final class MockOutputService
    extends MockArchive
    implements OutputService<MockArchiveDriverEntry> {
        boolean busy;

        MockOutputService(Map<String, MockArchiveDriverEntry> entries, TestConfig config) {
            super(entries, config);
        }

        public OutputSocket<MockArchiveDriverEntry> output(final MockArchiveDriverEntry entry) {
            Objects.requireNonNull(entry);
            final class Output
            extends AbstractOutputSocket<MockArchiveDriverEntry> {
                Output() {
                }

                public MockArchiveDriverEntry target() {
                    return entry;
                }

                public OutputStream stream(final InputSocket<? extends Entry> peer) throws IOException {
                    final class Stream
                    extends DecoratingOutputStream {
                        boolean closed;

                        Stream() throws IOException {
                            if (MockOutputService.this.busy) {
                                throw new IOException("Busy!");
                            }
                            this.out = this.socket().stream(peer);
                            MockOutputService.this.busy = true;
                        }

                        public void close() throws IOException {
                            if (this.closed) {
                                return;
                            }
                            this.out.close();
                            this.copyProperties();
                            this.closed = true;
                            MockOutputService.this.busy = false;
                        }
                    }
                    return new Stream();
                }

                OutputSocket<? extends IoBuffer> socket() throws IOException {
                    MockOutputService.this.entries.put(entry.getName(), entry);
                    return this.target().getBuffer(MockOutputService.this.getPool()).output();
                }

                void copyProperties() {
                    IoBuffer buffer;
                    MockArchiveDriverEntry target = this.target();
                    try {
                        buffer = target.getBuffer(MockOutputService.this.getPool());
                    }
                    catch (IOException ex) {
                        throw new AssertionError((Object)ex);
                    }
                    for (Entry.Size type : Entry.ALL_SIZES) {
                        target.setSize(type, buffer.getSize(type));
                    }
                    for (Entry.Size type : Entry.ALL_ACCESS) {
                        target.setTime((Entry.Access)type, buffer.getTime((Entry.Access)type));
                    }
                }
            }
            return new Output();
        }

        @DischargesObligation
        public void close() {
        }
    }

    private static final class MockInputService
    extends MockArchive
    implements InputService<MockArchiveDriverEntry> {
        MockInputService(Map<String, MockArchiveDriverEntry> entries, TestConfig config) {
            super(entries, config);
        }

        public InputSocket<MockArchiveDriverEntry> input(final String name) {
            Objects.requireNonNull(name);
            final class Input
            extends AbstractInputSocket<MockArchiveDriverEntry> {
                Input() {
                }

                public MockArchiveDriverEntry target() throws IOException {
                    MockArchiveDriverEntry entry = (MockArchiveDriverEntry)MockInputService.this.entries.get(name);
                    if (null == entry) {
                        throw new NoSuchFileException(name, null, "Entry not found!");
                    }
                    return entry;
                }

                public InputStream stream(OutputSocket<? extends Entry> peer) throws IOException {
                    return this.socket().stream(peer);
                }

                public SeekableByteChannel channel(OutputSocket<? extends Entry> peer) throws IOException {
                    return this.socket().channel(peer);
                }

                InputSocket<? extends IoBuffer> socket() throws IOException {
                    return this.target().getBuffer(MockInputService.this.getPool()).input();
                }
            }
            return new Input();
        }

        @DischargesObligation
        public void close() {
        }
    }
}

