/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.driver.mock;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.kernel.driver.mock.MockArchive;
import net.java.truevfs.kernel.driver.mock.MockArchiveDriverEntry;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;
import net.java.truevfs.kernel.spec.TestConfig;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputService;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;
import net.java.truevfs.kernel.spec.cio.OutputService;

@ThreadSafe
public class MockArchiveDriver
extends FsArchiveDriver<MockArchiveDriverEntry> {
    public static final Charset MOCK_CHARSET = Charset.forName("UTF-8");
    private final TestConfig config = TestConfig.get();
    private final ConcurrentMap<FsMountPoint, MockArchive> containers = new ConcurrentHashMap<FsMountPoint, MockArchive>(HashMaps.initialCapacity((int)this.config.getNumEntries()));

    public Charset getCharset() {
        return MOCK_CHARSET;
    }

    public IoBufferPool getPool() {
        return this.config.getPool();
    }

    protected InputService<MockArchiveDriverEntry> newInput(FsModel model, FsInputSocketSource input) throws IOException {
        FsMountPoint mp = model.getMountPoint();
        MockArchive c = (MockArchive)this.containers.get(mp);
        if (null == c) {
            throw new NoSuchFileException(mp.toString());
        }
        return c.newInputService();
    }

    protected OutputService<MockArchiveDriverEntry> newOutput(FsModel model, FsOutputSocketSink sink, @CheckForNull @WillNotClose InputService<MockArchiveDriverEntry> input) throws IOException {
        FsMountPoint mp = model.getMountPoint();
        MockArchive n = MockArchive.create(this.config);
        MockArchive o = (MockArchive)this.containers.get(mp);
        if (null == o) {
            o = this.containers.putIfAbsent(mp, n);
        }
        return new MultiplexingOutputService(this.getPool(), (null != o ? o : n).newOutputService());
    }

    public MockArchiveDriverEntry newEntry(BitField<FsAccessOption> options, String name, Entry.Type type, @CheckForNull Entry template) {
        return new MockArchiveDriverEntry(MockArchiveDriver.normalize((String)name, (Entry.Type)type), type, template);
    }
}

