/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.driver.mock;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.NoSuchFileException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.kernel.spec.FsAbstractController;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNode;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncOption;
import net.java.truevfs.kernel.spec.FsSyncWarningException;
import net.java.truevfs.kernel.spec.TestConfig;
import net.java.truevfs.kernel.spec.ThrowManager;
import net.java.truevfs.kernel.spec.cio.ByteArrayIoBuffer;
import net.java.truevfs.kernel.spec.cio.DelegatingInputSocket;
import net.java.truevfs.kernel.spec.cio.DelegatingOutputSocket;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoEntry;
import net.java.truevfs.kernel.spec.cio.OutputSocket;
import net.java.truevfs.kernel.spec.io.ThrowingInputStream;
import net.java.truevfs.kernel.spec.io.ThrowingOutputStream;
import net.java.truevfs.kernel.spec.io.ThrowingSeekableChannel;

@ThreadSafe
public class MockController
extends FsAbstractController {
    @Nullable
    private final FsController parent;
    private final ConcurrentMap<FsNodeName, IoEntry<?>> map = new ConcurrentHashMap();
    private final TestConfig config;
    @CheckForNull
    private volatile ThrowManager control;

    public MockController(FsModel model, @CheckForNull FsController parent) {
        this(model, parent, null);
    }

    public MockController(FsModel model, @CheckForNull FsController parent, @CheckForNull TestConfig config) {
        super(model);
        assert (null != model.getParent() ? model.getParent().equals(parent.getModel()) : null == parent);
        this.parent = parent;
        this.config = null != config ? config : TestConfig.get();
    }

    private ThrowManager getThrowControl() {
        ThrowManager control = this.control;
        return null != control ? control : (this.control = this.config.getThrowControl());
    }

    private void checkAllExceptions(Object thiz) throws IOException {
        this.getThrowControl().check(thiz, IOException.class);
        this.checkUndeclaredExceptions((Object)this);
    }

    private void checkUndeclaredExceptions(Object thiz) {
        this.getThrowControl().check(thiz, RuntimeException.class);
        this.getThrowControl().check(thiz, Error.class);
    }

    public FsController getParent() {
        this.checkUndeclaredExceptions((Object)this);
        return this.parent;
    }

    public FsNode node(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != options);
        throw new UnsupportedOperationException();
    }

    public void checkAccess(BitField<FsAccessOption> options, FsNodeName name, BitField<Entry.Access> types) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != options);
        assert (null != types);
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(FsNodeName name) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        throw new UnsupportedOperationException();
    }

    public boolean setTime(BitField<FsAccessOption> options, FsNodeName name, Map<Entry.Access, Long> times) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != times);
        assert (null != options);
        throw new UnsupportedOperationException();
    }

    public boolean setTime(BitField<FsAccessOption> options, FsNodeName name, BitField<Entry.Access> types, long value) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != types);
        assert (null != options);
        throw new UnsupportedOperationException();
    }

    public InputSocket<?> input(BitField<FsAccessOption> options, final FsNodeName name) {
        this.checkUndeclaredExceptions((Object)this);
        assert (null != name);
        assert (null != options);
        class Input
        extends DelegatingInputSocket<Entry> {
            Input() {
            }

            protected InputSocket<? extends Entry> socket() throws IOException {
                MockController.this.checkAllExceptions((Object)this);
                IoEntry buffer = (IoEntry)MockController.this.map.get(name);
                if (null == buffer) {
                    throw new NoSuchFileException(name.toString());
                }
                return buffer.input();
            }

            public SeekableByteChannel channel(OutputSocket<? extends Entry> peer) throws IOException {
                return new ThrowingSeekableChannel(this.socket().channel(peer), MockController.this.config.getThrowControl());
            }

            public InputStream stream(OutputSocket<? extends Entry> peer) throws IOException {
                return new ThrowingInputStream(this.socket().stream(peer), MockController.this.config.getThrowControl());
            }
        }
        return new Input();
    }

    public OutputSocket<?> output(BitField<FsAccessOption> options, final FsNodeName name, @CheckForNull Entry template) {
        this.checkUndeclaredExceptions((Object)this);
        assert (null != name);
        assert (null != options);
        class Output
        extends DelegatingOutputSocket<Entry> {
            Output() {
            }

            protected OutputSocket<? extends Entry> socket() throws IOException {
                MockController.this.checkAllExceptions((Object)this);
                ByteArrayIoBuffer n = new ByteArrayIoBuffer(name.toString(), MockController.this.config.getDataSize());
                IoEntry o = (IoEntry)MockController.this.map.get(name);
                if (null == o) {
                    o = (IoEntry)MockController.this.map.putIfAbsent(name, n);
                }
                return (null != o ? o : n).output();
            }

            public SeekableByteChannel channel(InputSocket<? extends Entry> peer) throws IOException {
                return new ThrowingSeekableChannel(this.socket().channel(peer), MockController.this.config.getThrowControl());
            }

            public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
                return new ThrowingOutputStream(this.socket().stream(peer), MockController.this.config.getThrowControl());
            }
        }
        return new Output();
    }

    public void make(BitField<FsAccessOption> options, FsNodeName name, Entry.Type type, Entry template) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != type);
        assert (null != options);
        throw new UnsupportedOperationException();
    }

    public void unlink(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        this.checkAllExceptions((Object)this);
        assert (null != name);
        assert (null != options);
        throw new UnsupportedOperationException();
    }

    public void sync(BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        this.getThrowControl().check((Object)this, FsSyncException.class);
        this.checkUndeclaredExceptions((Object)this);
        assert (null != options);
    }
}

