/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import edu.umd.cs.findbugs.annotations.When;
import java.io.IOException;
import java.util.Random;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.TestConfig;
import org.junit.After;
import org.junit.Before;
import org.slf4j.LoggerFactory;

public abstract class FsArchiveDriverTestBase<D extends FsArchiveDriver<?>> {
    private static final String ISOLATE_FS_MANAGER_PROPERTY_KEY = FsManager.class.getName() + ".isolate";
    protected static final boolean ISOLATE_FS_MANAGER = Boolean.getBoolean(ISOLATE_FS_MANAGER_PROPERTY_KEY);
    private static final byte[] DATA;
    private byte[] data;
    private volatile D driver;

    @Before
    @OverrideMustInvoke(value=When.FIRST)
    public void setUp() throws IOException {
        this.data = (byte[])DATA.clone();
        TestConfig config = TestConfig.push();
        config.setDataSize(this.data.length * 4 / 3);
        config.setPool(null);
    }

    @After
    @OverrideMustInvoke(value=When.LAST)
    public void tearDown() {
        TestConfig.pop();
    }

    protected final byte[] getData() {
        return this.data;
    }

    protected final int getDataLength() {
        return this.data.length;
    }

    protected final D getArchiveDriver() {
        D driver = this.driver;
        return null != driver ? driver : (this.driver = this.newArchiveDriver());
    }

    protected abstract D newArchiveDriver();

    static {
        LoggerFactory.getLogger(FsArchiveDriverTestBase.class).debug("Isolate file system manager: {}", (Object)ISOLATE_FS_MANAGER);
        DATA = new byte[1024];
        new Random().nextBytes(DATA);
    }
}

