/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URISyntaxException;
import java.util.Locale;
import net.java.truevfs.kernel.spec.FsScheme;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsSchemeTest {
    private static final Logger logger = LoggerFactory.getLogger(FsSchemeTest.class);

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (String[] params : new String[][]{{"foo"}, {"foo+bar"}, {"foo-bar"}, {"foo.bar"}, {"tar.bz2"}}) {
            Object clone;
            FsScheme original = FsScheme.create((String)params[0]);
            Assert.assertThat((Object)original.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(original);
            }
            logger.trace("Number of serialized bytes: {}", (Object)bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                clone = ois.readObject();
            }
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            clone = null;
            try {
                enc.setExceptionListener(listener);
                enc.writeObject(original);
            }
            catch (Throwable x2) {
                clone = x2;
                throw x2;
            }
            finally {
                if (enc != null) {
                    if (clone != null) {
                        try {
                            enc.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)clone).addSuppressed(x2);
                        }
                    } else {
                        enc.close();
                    }
                }
            }
            logger.trace("XML String: {}", (Object)bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            var11_15 = null;
            try (XMLDecoder dec = new XMLDecoder(bis);){
                clone = dec.readObject();
            }
            catch (Throwable throwable) {
                var11_15 = throwable;
                throw throwable;
            }
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
        }
    }

    @Test
    public void testConstructorWithInvalidUri() throws URISyntaxException {
        try {
            FsScheme.create(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsScheme(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        for (String param : new String[]{"", "+", "-", "."}) {
            try {
                FsScheme.create((String)param);
                Assert.fail((String)param);
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            try {
                new FsScheme(param);
                Assert.fail((String)param);
            }
            catch (URISyntaxException expected) {
                // empty catch block
            }
        }
    }

    @Test
    public void testEquality() {
        for (String[] params : new String[][]{{"foo"}, {"foo+bar"}, {"foo-bar"}, {"foo.bar"}, {"tar.bz2"}}) {
            FsScheme original = FsScheme.create((String)params[0]);
            FsScheme copy = FsScheme.create((String)params[0].toUpperCase(Locale.ROOT));
            Assert.assertThat((Object)original.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            Assert.assertThat((Object)copy.toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)params[0])));
            Assert.assertThat((Object)copy, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)copy.hashCode(), (Matcher)CoreMatchers.equalTo((Object)original.hashCode()));
            Assert.assertThat((Object)original.compareTo(copy), (Matcher)CoreMatchers.is((Object)0));
        }
    }
}

