/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.InheritableThreadLocalStack;
import net.java.truecommons.shed.Resource;
import net.java.truevfs.kernel.spec.ThrowManager;
import net.java.truevfs.kernel.spec.cio.ByteArrayIoBufferPool;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;

@CleanupObligation
@ThreadSafe
public final class TestConfig
extends Resource<RuntimeException> {
    public static final int DEFAULT_NUM_ENTRIES = 10;
    public static final int DEFAULT_DATA_LENGTH = 1024;
    private static final InheritableThreadLocalStack<TestConfig> configs = new InheritableThreadLocalStack();
    private static final TestConfig GLOBAL = new TestConfig();
    private final ThrowManager throwControl;
    private int numEmtries = 10;
    private int dataSize = 1024;
    private IoBufferPool pool;

    public static TestConfig get() {
        return (TestConfig)((Object)configs.peekOrElse((Object)GLOBAL));
    }

    @CreatesObligation
    public static TestConfig push() {
        return (TestConfig)((Object)configs.push((Object)new TestConfig(TestConfig.get())));
    }

    public static void pop() {
        configs.popIf((Object)TestConfig.get());
    }

    private TestConfig() {
        this.throwControl = new ThrowManager();
    }

    private TestConfig(TestConfig template) {
        this.throwControl = new ThrowManager(template.getThrowControl());
        this.numEmtries = template.getNumEntries();
        this.dataSize = template.getDataSize();
        this.pool = template.getPool();
    }

    public ThrowManager getThrowControl() {
        return this.throwControl;
    }

    public int getNumEntries() {
        return this.numEmtries;
    }

    public void setNumEntries(int numEntries) {
        if (0 > numEntries) {
            throw new IllegalArgumentException();
        }
        this.numEmtries = numEntries;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int size) {
        if (0 > size) {
            throw new IllegalArgumentException();
        }
        this.dataSize = size;
    }

    public IoBufferPool getPool() {
        IoBufferPool pool = this.pool;
        return null != pool ? pool : (this.pool = new ByteArrayIoBufferPool(this.getDataSize()));
    }

    public void setPool(@CheckForNull IoBufferPool pool) {
        this.pool = pool;
    }

    @DischargesObligation
    public void close() {
        super.close();
    }

    protected void onClose() {
        configs.popIf((Object)this);
    }
}

