/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.shed.Throwables;

@CleanupObligation
@NotThreadSafe
public final class ThrowManager {
    private final Map<Class<?>, Throwable> throwables;

    public ThrowManager() {
        this.throwables = new HashMap();
    }

    public ThrowManager(ThrowManager template) {
        this.throwables = new HashMap(template.throwables);
    }

    public Throwable trigger(Throwable toThrow) {
        return this.trigger(Object.class, toThrow);
    }

    public Throwable trigger(Class<?> from, Throwable toThrow) {
        Objects.requireNonNull(from);
        Throwables.wrap((Throwable)toThrow);
        return this.throwables.put(from, toThrow);
    }

    public Throwable clear(Class<?> from) {
        return this.throwables.remove(from);
    }

    public <X extends Throwable> void check(Object thiz, Class<X> throwz) throws X {
        this.check(thiz.getClass(), throwz);
    }

    private <X extends Throwable> void check(Class<?> thiz, Class<X> throwz) throws X {
        Throwable toThrow = this.throwables.remove(thiz);
        if (null != toThrow) {
            if (throwz.isInstance(toThrow)) {
                throw (Throwable)throwz.cast(Throwables.wrap((Throwable)toThrow));
            }
            this.throwables.put(thiz, toThrow);
        }
        for (Class<?> ic : thiz.getInterfaces()) {
            this.check(ic, throwz);
        }
        Class<?> sc = thiz.getSuperclass();
        if (null != sc) {
            this.check(sc, throwz);
        }
    }
}

