/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.cio;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.ByteBufferChannel;
import net.java.truecommons.io.DisconnectingInputStream;
import net.java.truecommons.io.DisconnectingOutputStream;
import net.java.truecommons.io.DisconnectingSeekableChannel;
import net.java.truevfs.kernel.spec.cio.AbstractInputSocket;
import net.java.truevfs.kernel.spec.cio.AbstractOutputSocket;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoBuffer;
import net.java.truevfs.kernel.spec.cio.OutputSocket;

@NotThreadSafe
public class ByteArrayIoBuffer
implements IoBuffer {
    private final String name;
    private int initialCapacity;
    @Nullable
    private byte[] data;
    private final EnumMap<Entry.Access, Long> times = new EnumMap(Entry.Access.class);
    private int reads;
    private int writes;

    public ByteArrayIoBuffer(String name, int initialCapacity) {
        this(name, null, initialCapacity);
    }

    public ByteArrayIoBuffer(String name, byte[] data) {
        this(name, data, data.length);
    }

    private ByteArrayIoBuffer(String name, @CheckForNull byte[] data, int initialCapacity) {
        this.name = Objects.requireNonNull(name);
        this.setData(data);
        this.setInitialCapacity(initialCapacity);
    }

    public final int getInitialCapacity() {
        return this.initialCapacity;
    }

    public final void setInitialCapacity(int initialCapacity) {
        if (0 > initialCapacity) {
            throw new IllegalArgumentException("Negative initial capacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    @Nullable
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public final byte[] getData() {
        return this.data;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public final void setData(@CheckForNull byte[] data) {
        this.data = data;
    }

    public final String getName() {
        return this.name;
    }

    public final long getSize(Entry.Size type) {
        return null != this.data ? (long)this.data.length : -1L;
    }

    public final int getCount(Entry.Access type) {
        return type == Entry.Access.WRITE ? this.writes : this.reads;
    }

    public final long getTime(Entry.Access type) {
        Long time = this.times.get(type);
        return null != time ? time : -1L;
    }

    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        return true;
    }

    public final InputSocket<ByteArrayIoBuffer> input() {
        return new Input();
    }

    public final OutputSocket<ByteArrayIoBuffer> output() {
        return new Output();
    }

    public String toString() {
        return String.format("%s[name=%s]", this.getClass().getName(), this.getName());
    }

    public void release() throws IOException {
    }

    static /* synthetic */ byte[] access$202(ByteArrayIoBuffer x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    private final class DataOutputStream
    extends DisconnectingOutputStream {
        boolean closed;

        DataOutputStream() {
            super((OutputStream)new ByteArrayOutputStream(ByteArrayIoBuffer.this.initialCapacity));
        }

        public boolean isOpen() {
            return !this.closed;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.out.close();
            ByteArrayIoBuffer.this.times.put(Entry.Access.WRITE, System.currentTimeMillis());
            ByteArrayIoBuffer.access$202(ByteArrayIoBuffer.this, ((ByteArrayOutputStream)this.out).toByteArray());
            this.closed = true;
        }
    }

    private final class DataInputStream
    extends DisconnectingInputStream {
        boolean closed;

        DataInputStream() {
            super((InputStream)new ByteArrayInputStream(ByteArrayIoBuffer.this.data));
        }

        public boolean isOpen() {
            return !this.closed;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.in.close();
            ByteArrayIoBuffer.this.times.put(Entry.Access.READ, System.currentTimeMillis());
            this.closed = true;
        }
    }

    private final class DataOutputChannel
    extends DisconnectingSeekableChannel {
        boolean closed;

        @CreatesObligation
        DataOutputChannel() {
            super((SeekableByteChannel)new ByteBufferChannel((ByteBuffer)ByteBuffer.allocate(ByteArrayIoBuffer.this.initialCapacity).limit(0)));
        }

        public boolean isOpen() {
            return !this.closed;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            ByteArrayIoBuffer.this.times.put(Entry.Access.WRITE, System.currentTimeMillis());
            ByteBuffer buffer = ((ByteBufferChannel)this.channel).bufferDuplicate();
            ByteArrayIoBuffer.access$202(ByteArrayIoBuffer.this, Arrays.copyOf(buffer.array(), buffer.limit()));
            this.closed = true;
        }
    }

    private final class DataInputChannel
    extends DisconnectingSeekableChannel {
        boolean closed;

        @CreatesObligation
        DataInputChannel() {
            super((SeekableByteChannel)new ByteBufferChannel(ByteBuffer.wrap(ByteArrayIoBuffer.this.data).asReadOnlyBuffer()));
        }

        public boolean isOpen() {
            return !this.closed;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            ByteArrayIoBuffer.this.times.put(Entry.Access.READ, System.currentTimeMillis());
            this.closed = true;
        }
    }

    private final class Output
    extends AbstractOutputSocket<ByteArrayIoBuffer> {
        private Output() {
        }

        public ByteArrayIoBuffer target() throws IOException {
            return ByteArrayIoBuffer.this;
        }

        void count() {
            ByteArrayIoBuffer.this.writes++;
        }

        public SeekableByteChannel channel(InputSocket<? extends Entry> _) throws IOException {
            this.count();
            return new DataOutputChannel();
        }

        public OutputStream stream(InputSocket<? extends Entry> _) throws IOException {
            this.count();
            return new DataOutputStream();
        }
    }

    private final class Input
    extends AbstractInputSocket<ByteArrayIoBuffer> {
        private Input() {
        }

        public ByteArrayIoBuffer target() throws IOException {
            return ByteArrayIoBuffer.this;
        }

        void count() throws FileNotFoundException {
            if (null == ByteArrayIoBuffer.this.data) {
                throw new FileNotFoundException();
            }
            ByteArrayIoBuffer.this.reads++;
        }

        public InputStream stream(OutputSocket<? extends Entry> _) throws IOException {
            this.count();
            return new DataInputStream();
        }

        public SeekableByteChannel channel(OutputSocket<? extends Entry> _) throws IOException {
            this.count();
            return new DataInputChannel();
        }
    }
}

