/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.cio;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truevfs.kernel.spec.cio.ByteArrayIoBuffer;
import net.java.truevfs.kernel.spec.cio.IoBuffer;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;

@ThreadSafe
public final class ByteArrayIoBufferPool
extends IoBufferPool {
    private static final String BUFFER_NAME = "buffer-";
    private final int initialCapacity;
    private final AtomicInteger total = new AtomicInteger();
    private final AtomicInteger active = new AtomicInteger();

    public ByteArrayIoBufferPool(int initialCapacity) {
        if (0 > initialCapacity) {
            throw new IllegalArgumentException("Negative initial capacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    public IoBuffer allocate() {
        ByteIoBuffer buffer = new ByteIoBuffer(this.total.getAndIncrement());
        this.active.getAndIncrement();
        return buffer;
    }

    public int size() {
        return this.active.get();
    }

    @NotThreadSafe
    private final class ByteIoBuffer
    extends ByteArrayIoBuffer {
        private boolean released;

        ByteIoBuffer(int i) {
            super(ByteArrayIoBufferPool.BUFFER_NAME + i, ByteArrayIoBufferPool.this.initialCapacity);
        }

        @Override
        public void release() throws IOException {
            if (this.released) {
                throw new IllegalStateException("entry has already been released!");
            }
            ByteArrayIoBufferPool.this.active.getAndDecrement();
            this.setData(null);
            this.released = true;
        }
    }
}

