/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.cio;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truevfs.kernel.spec.TestConfig;
import net.java.truevfs.kernel.spec.ThrowManager;
import net.java.truevfs.kernel.spec.cio.DecoratingOutputService;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.OutputService;
import net.java.truevfs.kernel.spec.cio.OutputSocket;

@ThreadSafe
public class ThrowingOutputService<E extends Entry>
extends DecoratingOutputService<E> {
    private final TestConfig config;
    @CheckForNull
    private volatile ThrowManager control;

    public ThrowingOutputService(@WillCloseWhenClosed OutputService<E> service) {
        this(service, null);
    }

    public ThrowingOutputService(@WillCloseWhenClosed OutputService<E> service, @CheckForNull TestConfig config) {
        super(service);
        this.config = null != config ? config : TestConfig.get();
    }

    private ThrowManager getThrowControl() {
        ThrowManager control = this.control;
        return null != control ? control : (this.control = this.config.getThrowControl());
    }

    private void checkAllExceptions() throws IOException {
        this.getThrowControl().check((Object)this, IOException.class);
        this.checkUndeclaredExceptions();
    }

    private void checkUndeclaredExceptions() {
        this.getThrowControl().check((Object)this, RuntimeException.class);
        this.getThrowControl().check((Object)this, Error.class);
    }

    public int size() {
        this.checkUndeclaredExceptions();
        return ((OutputService)this.container).size();
    }

    public Iterator<E> iterator() {
        this.checkUndeclaredExceptions();
        return ((OutputService)this.container).iterator();
    }

    public E entry(String name) {
        this.checkUndeclaredExceptions();
        return (E)((OutputService)this.container).entry(name);
    }

    @DischargesObligation
    public void close() throws IOException {
        this.checkAllExceptions();
        ((OutputService)this.container).close();
    }

    public OutputSocket<E> output(E entry) {
        this.checkUndeclaredExceptions();
        return ((OutputService)this.container).output(entry);
    }
}

