/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec.spi;

import java.util.Map;
import net.java.truecommons.shed.ExtensionSet;
import net.java.truevfs.kernel.spec.FsDriver;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.sl.FsDriverMapLocator;
import net.java.truevfs.kernel.spec.spi.FsDriverMapFactory;
import net.java.truevfs.kernel.spec.spi.FsDriverMapModifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class FsDriverMapModifierTestSuite {
    protected abstract String getExtensions();

    protected abstract FsDriverMapModifier newModifier();

    @Test
    public void testApply() {
        Map map = new FsDriverMapFactory().get();
        Assert.assertThat((Object)this.newModifier().apply((Object)map), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)map)));
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0)));
        for (String extension : new ExtensionSet(this.getExtensions())) {
            Assert.assertThat(map.get(FsScheme.create((String)extension)), (Matcher)CoreMatchers.notNullValue());
        }
    }

    @Test
    public void testIsLocatable() {
        Map modified = (Map)this.newModifier().apply((Object)new FsDriverMapFactory().get());
        Map located = FsDriverMapLocator.SINGLETON.get();
        for (FsScheme scheme : modified.keySet()) {
            Assert.assertThat(located.get(scheme), (Matcher)CoreMatchers.instanceOf(((FsDriver)modified.get(scheme)).getClass()));
        }
    }
}

