/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.json2xml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import net.javacrumbs.json2xml.ElementNameConverter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JsonSaxAdapter {
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private final JsonParser jsonParser;
    private final ContentHandler contentHandler;
    private final String namespaceUri;
    private final boolean addTypeAttributes;
    private final String artificialRootName;
    private final ElementNameConverter nameConverter;
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    public JsonSaxAdapter(String json, ContentHandler contentHandler) {
        this(JsonSaxAdapter.parseJson(json), contentHandler);
    }

    public JsonSaxAdapter(JsonParser jsonParser, ContentHandler contentHandler) {
        this(jsonParser, contentHandler, "");
    }

    public JsonSaxAdapter(JsonParser jsonParser, ContentHandler contentHandler, String namespaceUri) {
        this(jsonParser, contentHandler, namespaceUri, false);
    }

    public JsonSaxAdapter(JsonParser jsonParser, ContentHandler contentHandler, String namespaceUri, boolean addTypeAttributes) {
        this(jsonParser, contentHandler, namespaceUri, addTypeAttributes, null);
    }

    public JsonSaxAdapter(JsonParser jsonParser, ContentHandler contentHandler, String namespaceUri, boolean addTypeAttributes, String artificialRootName) {
        this(jsonParser, contentHandler, namespaceUri, addTypeAttributes, artificialRootName, null);
    }

    public JsonSaxAdapter(JsonParser jsonParser, ContentHandler contentHandler, String namespaceUri, boolean addTypeAttributes, String artificialRootName, ElementNameConverter nameConverter) {
        this.jsonParser = jsonParser;
        this.contentHandler = contentHandler;
        this.namespaceUri = namespaceUri;
        this.addTypeAttributes = addTypeAttributes;
        this.artificialRootName = artificialRootName;
        this.nameConverter = nameConverter;
        contentHandler.setDocumentLocator(new DocumentLocator());
    }

    private static JsonParser parseJson(String json) {
        try {
            return JSON_FACTORY.createParser(json);
        }
        catch (Exception e) {
            throw new ParserException("Parsing error", e);
        }
    }

    public void parse() throws ParserException {
        try {
            this.jsonParser.nextToken();
            this.contentHandler.startDocument();
            if (this.shouldAddArtificialRoot()) {
                this.startElement(this.artificialRootName);
                this.parseElement(this.artificialRootName, false);
                this.endElement(this.artificialRootName);
            } else if (JsonToken.START_OBJECT.equals((Object)this.jsonParser.getCurrentToken())) {
                int elementsWritten = this.parseObject();
                if (elementsWritten > 1) {
                    throw new ParserException("More than one root element. Can not generate legal XML. You can set artificialRootName to generate an artificial root.");
                }
            } else {
                throw new ParserException("Unsupported root element. Can not generate legal XML. You can set artificialRootName to generate an artificial root.");
            }
            this.contentHandler.endDocument();
        }
        catch (Exception e) {
            throw new ParserException("Parsing error: " + e.getMessage(), e);
        }
    }

    private boolean shouldAddArtificialRoot() {
        return this.artificialRootName != null && this.artificialRootName.length() > 0;
    }

    private int parseObject() throws Exception {
        int elementsWritten = 0;
        while (this.jsonParser.nextToken() != null && this.jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            if (JsonToken.FIELD_NAME.equals((Object)this.jsonParser.getCurrentToken())) {
                String elementName = this.convertName(this.jsonParser.getCurrentName());
                this.jsonParser.nextToken();
                this.startElement(elementName);
                this.parseElement(elementName, false);
                this.endElement(elementName);
                ++elementsWritten;
                continue;
            }
            throw new ParserException("Error when parsing. Expected field name got " + this.jsonParser.getCurrentToken());
        }
        return elementsWritten;
    }

    private String convertName(String name) {
        if (this.nameConverter != null) {
            return this.nameConverter.convertName(name);
        }
        return name;
    }

    private void parseElement(String elementName, boolean inArray) throws Exception {
        JsonToken currentToken = this.jsonParser.getCurrentToken();
        if (inArray) {
            this.startElement(elementName);
        }
        if (JsonToken.START_OBJECT.equals((Object)currentToken)) {
            this.parseObject();
        } else if (JsonToken.START_ARRAY.equals((Object)currentToken)) {
            this.parseArray(elementName);
        } else if (currentToken.isScalarValue()) {
            this.parseValue();
        }
        if (inArray) {
            this.endElement(elementName);
        }
    }

    private void parseArray(String elementName) throws Exception {
        while (this.jsonParser.nextToken() != JsonToken.END_ARRAY && this.jsonParser.getCurrentToken() != null) {
            this.parseElement(elementName, true);
        }
    }

    private void parseValue() throws Exception {
        if (JsonToken.VALUE_NULL != this.jsonParser.getCurrentToken()) {
            String text = this.jsonParser.getText();
            this.contentHandler.characters(text.toCharArray(), 0, text.length());
        }
    }

    private void startElement(String elementName) throws SAXException {
        this.contentHandler.startElement(this.namespaceUri, elementName, elementName, this.getTypeAttributes());
    }

    protected Attributes getTypeAttributes() {
        if (this.addTypeAttributes) {
            String currentTokenType = this.getCurrentTokenType();
            if (currentTokenType != null) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "type", "type", "string", currentTokenType);
                return attributes;
            }
            return EMPTY_ATTRIBUTES;
        }
        return EMPTY_ATTRIBUTES;
    }

    protected String getCurrentTokenType() {
        switch (this.jsonParser.getCurrentToken()) {
            case VALUE_NUMBER_INT: {
                return "int";
            }
            case VALUE_NUMBER_FLOAT: {
                return "float";
            }
            case VALUE_FALSE: {
                return "boolean";
            }
            case VALUE_TRUE: {
                return "boolean";
            }
            case VALUE_STRING: {
                return "string";
            }
            case VALUE_NULL: {
                return "null";
            }
            case START_ARRAY: {
                return "array";
            }
        }
        return null;
    }

    private void endElement(String elementName) throws SAXException {
        this.contentHandler.endElement(this.namespaceUri, elementName, elementName);
    }

    private class DocumentLocator
    implements Locator {
        private DocumentLocator() {
        }

        public String getPublicId() {
            Object sourceRef = JsonSaxAdapter.this.jsonParser.getCurrentLocation().getSourceRef();
            if (sourceRef != null) {
                return sourceRef.toString();
            }
            return "";
        }

        public String getSystemId() {
            return this.getPublicId();
        }

        public int getLineNumber() {
            return JsonSaxAdapter.this.jsonParser.getCurrentLocation() != null ? JsonSaxAdapter.this.jsonParser.getCurrentLocation().getLineNr() : -1;
        }

        public int getColumnNumber() {
            return JsonSaxAdapter.this.jsonParser.getCurrentLocation() != null ? JsonSaxAdapter.this.jsonParser.getCurrentLocation().getColumnNr() : -1;
        }
    }

    public static class ParserException
    extends RuntimeException {
        private static final long serialVersionUID = 2194022343599245018L;

        public ParserException(String message, Throwable cause) {
            super(message, cause);
        }

        public ParserException(String message) {
            super(message);
        }

        public ParserException(Throwable cause) {
            super(cause);
        }
    }
}

