/*
 * Decompiled with CFR 0.152.
 */
package net.jfsanchez.netty.handler.logging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.jfsanchez.netty.handler.logging.DefaultLogStatementHandlerImpl;
import net.jfsanchez.netty.handler.logging.LogStatementHandler;
import net.jfsanchez.netty.handler.logging.provider.BodyStatementProvider;
import net.jfsanchez.netty.handler.logging.provider.HeaderStatementProvider;
import net.jfsanchez.netty.handler.logging.provider.impl.DefaultBodyStatementProviderImpl;
import net.jfsanchez.netty.handler.logging.provider.impl.DefaultHeaderStatementProviderImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u000ej\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnet/jfsanchez/netty/handler/logging/PlainTextHttpLoggingHandler;", "Lio/netty/channel/ChannelDuplexHandler;", "headerStatementProvider", "Lnet/jfsanchez/netty/handler/logging/provider/HeaderStatementProvider;", "bodyStatementProvider", "Lnet/jfsanchez/netty/handler/logging/provider/BodyStatementProvider;", "handler", "Lnet/jfsanchez/netty/handler/logging/LogStatementHandler;", "(Lnet/jfsanchez/netty/handler/logging/provider/HeaderStatementProvider;Lnet/jfsanchez/netty/handler/logging/provider/BodyStatementProvider;Lnet/jfsanchez/netty/handler/logging/LogStatementHandler;)V", "fullHttpRequestBuilder", "Lnet/jfsanchez/netty/handler/logging/PlainTextHttpLoggingHandler$FullHttpRequestBuilder;", "fullHttpResponseBuilder", "Lnet/jfsanchez/netty/handler/logging/PlainTextHttpLoggingHandler$FullHttpResponseBuilder;", "requestContent", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "responseContent", "channelInactive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead", "msg", "", "logAndReset", "write", "promise", "Lio/netty/channel/ChannelPromise;", "FullHttpRequestBuilder", "FullHttpResponseBuilder", "plaintext-logging-handler"})
public class PlainTextHttpLoggingHandler
extends ChannelDuplexHandler {
    @NotNull
    private final HeaderStatementProvider headerStatementProvider;
    @NotNull
    private final BodyStatementProvider bodyStatementProvider;
    @NotNull
    private final LogStatementHandler handler;
    @NotNull
    private final StringBuilder requestContent;
    @NotNull
    private final StringBuilder responseContent;
    @NotNull
    private final FullHttpRequestBuilder fullHttpRequestBuilder;
    @NotNull
    private final FullHttpResponseBuilder fullHttpResponseBuilder;

    public PlainTextHttpLoggingHandler(@NotNull HeaderStatementProvider headerStatementProvider, @NotNull BodyStatementProvider bodyStatementProvider, @NotNull LogStatementHandler handler) {
        Intrinsics.checkNotNullParameter((Object)headerStatementProvider, (String)"headerStatementProvider");
        Intrinsics.checkNotNullParameter((Object)bodyStatementProvider, (String)"bodyStatementProvider");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.headerStatementProvider = headerStatementProvider;
        this.bodyStatementProvider = bodyStatementProvider;
        this.handler = handler;
        this.requestContent = new StringBuilder();
        this.responseContent = new StringBuilder();
        this.fullHttpRequestBuilder = new FullHttpRequestBuilder();
        this.fullHttpResponseBuilder = new FullHttpResponseBuilder();
    }

    public /* synthetic */ PlainTextHttpLoggingHandler(HeaderStatementProvider headerStatementProvider, BodyStatementProvider bodyStatementProvider, LogStatementHandler logStatementHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            headerStatementProvider = new DefaultHeaderStatementProviderImpl();
        }
        if ((n & 2) != 0) {
            bodyStatementProvider = new DefaultBodyStatementProviderImpl();
        }
        if ((n & 4) != 0) {
            logStatementHandler = new DefaultLogStatementHandlerImpl(null, null, 3, null);
        }
        this(headerStatementProvider, bodyStatementProvider, logStatementHandler);
    }

    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        Object object = msg;
        if (object instanceof HttpRequest) {
            HttpVersion httpVersion = ((HttpRequest)msg).protocolVersion();
            Intrinsics.checkNotNullExpressionValue((Object)httpVersion, (String)"msg.protocolVersion()");
            FullHttpRequestBuilder fullHttpRequestBuilder = this.fullHttpRequestBuilder.httpVersion(httpVersion);
            String string = ((HttpRequest)msg).uri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"msg.uri()");
            FullHttpRequestBuilder fullHttpRequestBuilder2 = fullHttpRequestBuilder.uri(string);
            HttpMethod httpMethod = ((HttpRequest)msg).method();
            Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"msg.method()");
            FullHttpRequestBuilder fullHttpRequestBuilder3 = fullHttpRequestBuilder2.httpMethod(httpMethod);
            HttpHeaders httpHeaders = ((HttpRequest)msg).headers();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"msg.headers()");
            fullHttpRequestBuilder3.headers(httpHeaders);
        } else if (object instanceof ByteBuf) {
            this.fullHttpRequestBuilder.appendContent((ByteBuf)msg);
        } else if (object instanceof HttpContent) {
            ByteBuf byteBuf = ((HttpContent)msg).content();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"msg.content()");
            this.fullHttpRequestBuilder.appendContent(byteBuf);
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Object object = msg;
        if (object instanceof HttpResponse) {
            HttpVersion httpVersion = ((HttpResponse)msg).protocolVersion();
            Intrinsics.checkNotNullExpressionValue((Object)httpVersion, (String)"msg.protocolVersion()");
            FullHttpResponseBuilder fullHttpResponseBuilder = this.fullHttpResponseBuilder.httpVersion(httpVersion);
            HttpHeaders httpHeaders = ((HttpResponse)msg).headers();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"msg.headers()");
            FullHttpResponseBuilder fullHttpResponseBuilder2 = fullHttpResponseBuilder.headers(httpHeaders);
            HttpResponseStatus httpResponseStatus = ((HttpResponse)msg).status();
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"msg.status()");
            fullHttpResponseBuilder2.responseStatus(httpResponseStatus);
        } else if (object instanceof ByteBuf) {
            this.fullHttpResponseBuilder.appendContent((ByteBuf)msg);
        } else if (object instanceof HttpContent) {
            ByteBuf byteBuf = ((HttpContent)msg).content();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"msg.content()");
            this.fullHttpResponseBuilder.appendContent(byteBuf);
        }
        ctx.fireChannelRead(msg);
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.logAndReset(ctx);
        super.channelInactive(ctx);
    }

    private final void logAndReset(ChannelHandlerContext ctx) {
        StringBuilder stringBuilder;
        DefaultFullHttpRequest request = this.fullHttpRequestBuilder.build();
        boolean bl = false;
        this.requestContent.append(this.headerStatementProvider.requestHeader((HttpRequest)request));
        if (request.content().readableBytes() > 0) {
            stringBuilder = this.requestContent;
            ByteBuf byteBuf = request.content();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"request.content()");
            StringBuilder stringBuilder2 = stringBuilder.append(this.bodyStatementProvider.requestBody(byteBuf));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        request.content().release();
        DefaultFullHttpResponse response = this.fullHttpResponseBuilder.build();
        boolean bl2 = false;
        this.responseContent.append(this.headerStatementProvider.responseHeader((HttpResponse)response));
        if (response.content().readableBytes() > 0) {
            stringBuilder = this.responseContent;
            ByteBuf byteBuf = response.content();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"response.content()");
            StringBuilder stringBuilder3 = stringBuilder.append(this.bodyStatementProvider.responseBody(byteBuf));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        response.content().release();
        StringBuilder statement = new StringBuilder();
        boolean bl3 = false;
        StringBuilder stringBuilder4 = statement.append(this.requestContent.toString());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringBuilder stringBuilder5 = stringBuilder4.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append('\\n')");
        StringBuilder stringBuilder6 = stringBuilder5.append(this.responseContent.toString());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        StringsKt.clear((StringBuilder)this.requestContent);
        StringsKt.clear((StringBuilder)this.responseContent);
        Channel channel = ctx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"ctx.channel()");
        String string = statement.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"statement.toString()");
        this.handler.handle(channel, string);
    }

    public PlainTextHttpLoggingHandler() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/jfsanchez/netty/handler/logging/PlainTextHttpLoggingHandler$FullHttpResponseBuilder;", "", "()V", "content", "Lio/netty/buffer/ByteBuf;", "headers", "Lio/netty/handler/codec/http/HttpHeaders;", "httpVersion", "Lio/netty/handler/codec/http/HttpVersion;", "responseStatus", "Lio/netty/handler/codec/http/HttpResponseStatus;", "appendContent", "build", "Lio/netty/handler/codec/http/DefaultFullHttpResponse;", "plaintext-logging-handler"})
    public static final class FullHttpResponseBuilder {
        private HttpVersion httpVersion;
        private HttpResponseStatus responseStatus;
        @NotNull
        private final ByteBuf content;
        private HttpHeaders headers;

        public FullHttpResponseBuilder() {
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"DEFAULT.buffer()");
            this.content = byteBuf;
        }

        @NotNull
        public final FullHttpResponseBuilder httpVersion(@NotNull HttpVersion httpVersion) {
            FullHttpResponseBuilder fullHttpResponseBuilder;
            Intrinsics.checkNotNullParameter((Object)httpVersion, (String)"httpVersion");
            FullHttpResponseBuilder $this$httpVersion_u24lambda_u2d0 = fullHttpResponseBuilder = this;
            boolean bl = false;
            $this$httpVersion_u24lambda_u2d0.httpVersion = httpVersion;
            return fullHttpResponseBuilder;
        }

        @NotNull
        public final FullHttpResponseBuilder responseStatus(@NotNull HttpResponseStatus responseStatus) {
            FullHttpResponseBuilder fullHttpResponseBuilder;
            Intrinsics.checkNotNullParameter((Object)responseStatus, (String)"responseStatus");
            FullHttpResponseBuilder $this$responseStatus_u24lambda_u2d1 = fullHttpResponseBuilder = this;
            boolean bl = false;
            $this$responseStatus_u24lambda_u2d1.responseStatus = responseStatus;
            return fullHttpResponseBuilder;
        }

        @NotNull
        public final FullHttpResponseBuilder appendContent(@NotNull ByteBuf content) {
            FullHttpResponseBuilder fullHttpResponseBuilder;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            FullHttpResponseBuilder it = fullHttpResponseBuilder = this;
            boolean bl = false;
            this.content.writeBytes(content);
            return fullHttpResponseBuilder;
        }

        @NotNull
        public final FullHttpResponseBuilder headers(@NotNull HttpHeaders headers) {
            FullHttpResponseBuilder fullHttpResponseBuilder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            FullHttpResponseBuilder $this$headers_u24lambda_u2d3 = fullHttpResponseBuilder = this;
            boolean bl = false;
            $this$headers_u24lambda_u2d3.headers = headers;
            return fullHttpResponseBuilder;
        }

        @NotNull
        public final DefaultFullHttpResponse build() {
            HttpHeaders httpHeaders;
            HttpHeaders httpHeaders2;
            HttpResponseStatus httpResponseStatus;
            HttpVersion httpVersion = this.httpVersion;
            if (httpVersion == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"httpVersion");
                httpVersion = null;
            }
            if ((httpResponseStatus = this.responseStatus) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"responseStatus");
                httpResponseStatus = null;
            }
            if ((httpHeaders2 = this.headers) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"headers");
                httpHeaders2 = null;
            }
            if ((httpHeaders = this.headers) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"headers");
                httpHeaders = null;
            }
            return new DefaultFullHttpResponse(httpVersion, httpResponseStatus, this.content, httpHeaders2, httpHeaders);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/jfsanchez/netty/handler/logging/PlainTextHttpLoggingHandler$FullHttpRequestBuilder;", "", "()V", "content", "Lio/netty/buffer/ByteBuf;", "headers", "Lio/netty/handler/codec/http/HttpHeaders;", "httpMethod", "Lio/netty/handler/codec/http/HttpMethod;", "httpVersion", "Lio/netty/handler/codec/http/HttpVersion;", "uri", "", "appendContent", "build", "Lio/netty/handler/codec/http/DefaultFullHttpRequest;", "plaintext-logging-handler"})
    public static final class FullHttpRequestBuilder {
        private HttpVersion httpVersion;
        private HttpMethod httpMethod;
        private String uri;
        @NotNull
        private final ByteBuf content;
        private HttpHeaders headers;

        public FullHttpRequestBuilder() {
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"DEFAULT.buffer()");
            this.content = byteBuf;
        }

        @NotNull
        public final FullHttpRequestBuilder httpVersion(@NotNull HttpVersion httpVersion) {
            FullHttpRequestBuilder fullHttpRequestBuilder;
            Intrinsics.checkNotNullParameter((Object)httpVersion, (String)"httpVersion");
            FullHttpRequestBuilder $this$httpVersion_u24lambda_u2d0 = fullHttpRequestBuilder = this;
            boolean bl = false;
            $this$httpVersion_u24lambda_u2d0.httpVersion = httpVersion;
            return fullHttpRequestBuilder;
        }

        @NotNull
        public final FullHttpRequestBuilder httpMethod(@NotNull HttpMethod httpMethod) {
            FullHttpRequestBuilder fullHttpRequestBuilder;
            Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
            FullHttpRequestBuilder $this$httpMethod_u24lambda_u2d1 = fullHttpRequestBuilder = this;
            boolean bl = false;
            $this$httpMethod_u24lambda_u2d1.httpMethod = httpMethod;
            return fullHttpRequestBuilder;
        }

        @NotNull
        public final FullHttpRequestBuilder uri(@NotNull String uri) {
            FullHttpRequestBuilder fullHttpRequestBuilder;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            FullHttpRequestBuilder $this$uri_u24lambda_u2d2 = fullHttpRequestBuilder = this;
            boolean bl = false;
            $this$uri_u24lambda_u2d2.uri = uri;
            return fullHttpRequestBuilder;
        }

        @NotNull
        public final FullHttpRequestBuilder appendContent(@NotNull ByteBuf content) {
            FullHttpRequestBuilder fullHttpRequestBuilder;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            FullHttpRequestBuilder it = fullHttpRequestBuilder = this;
            boolean bl = false;
            this.content.writeBytes(content);
            return fullHttpRequestBuilder;
        }

        @NotNull
        public final FullHttpRequestBuilder headers(@NotNull HttpHeaders headers) {
            FullHttpRequestBuilder fullHttpRequestBuilder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            FullHttpRequestBuilder $this$headers_u24lambda_u2d4 = fullHttpRequestBuilder = this;
            boolean bl = false;
            $this$headers_u24lambda_u2d4.headers = headers;
            return fullHttpRequestBuilder;
        }

        @NotNull
        public final DefaultFullHttpRequest build() {
            HttpHeaders httpHeaders;
            HttpHeaders httpHeaders2;
            String string;
            HttpMethod httpMethod;
            HttpVersion httpVersion = this.httpVersion;
            if (httpVersion == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"httpVersion");
                httpVersion = null;
            }
            if ((httpMethod = this.httpMethod) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"httpMethod");
                httpMethod = null;
            }
            if ((string = this.uri) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                string = null;
            }
            if ((httpHeaders2 = this.headers) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"headers");
                httpHeaders2 = null;
            }
            if ((httpHeaders = this.headers) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"headers");
                httpHeaders = null;
            }
            return new DefaultFullHttpRequest(httpVersion, httpMethod, string, this.content, httpHeaders2, httpHeaders);
        }
    }
}

