/*
 * Decompiled with CFR 0.152.
 */
package net.joningi.icndb;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.List;
import net.joningi.icndb.APIService;
import net.joningi.icndb.Joke;
import net.joningi.icndb.QueryString;

public class ICNDBClient {
    private final APIService apiService = new APIService();
    private String firstName;
    private String lastName;
    private List<String> limitTo;
    private List<String> exclude;

    public Joke getById(int id) {
        return this.apiService.get("jokes/" + id + this.buildParameters()).getJoke();
    }

    private String buildParameters() {
        QueryString queryString = new QueryString();
        if (!Strings.isNullOrEmpty((String)this.firstName)) {
            queryString.add("firstName", this.firstName);
        }
        if (!Strings.isNullOrEmpty((String)this.lastName)) {
            queryString.add("lastName", this.lastName);
        }
        if (this.limitTo != null) {
            queryString.add("limitTo", '[' + Joiner.on((char)',').join(this.limitTo) + ']');
        }
        if (this.exclude != null) {
            queryString.add("exclude", '[' + Joiner.on((char)',').join(this.exclude) + ']');
        }
        return queryString.toString();
    }

    public Joke getRandom() {
        return this.apiService.get("jokes/random" + this.buildParameters()).getJoke();
    }

    public List<Joke> getRandom(int count) {
        return this.apiService.getMulti("jokes/random/" + count + this.buildParameters()).getJokes();
    }

    public int getCount() {
        return this.apiService.getCount();
    }

    public List<String> getCategories() {
        return this.apiService.getCategories();
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void clearName() {
        this.firstName = null;
        this.lastName = null;
    }

    public void setLimitTo(List<String> list) {
        this.limitTo = list;
    }

    public void setExclude(List<String> list) {
        this.exclude = list;
    }

    public void clearLimitAndExclude() {
        this.limitTo = null;
        this.exclude = null;
    }
}

