/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.dependency.digraph.maven.plugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kemitix.dependency.digraph.maven.plugin.DotFileFormat;
import net.kemitix.dependency.digraph.maven.plugin.NodeHelper;
import net.kemitix.dependency.digraph.maven.plugin.NodePackageDataComparator;
import net.kemitix.dependency.digraph.maven.plugin.NodePathGenerator;
import net.kemitix.dependency.digraph.maven.plugin.PackageData;
import net.kemitix.dependency.digraph.maven.plugin.digraph.Digraph;
import net.kemitix.dependency.digraph.maven.plugin.digraph.EdgeElement;
import net.kemitix.dependency.digraph.maven.plugin.digraph.EdgeEndpoint;
import net.kemitix.dependency.digraph.maven.plugin.digraph.ElementContainer;
import net.kemitix.dependency.digraph.maven.plugin.digraph.GraphElement;
import net.kemitix.dependency.digraph.maven.plugin.digraph.NodeElement;
import net.kemitix.dependency.digraph.maven.plugin.digraph.NodeProperties;
import net.kemitix.dependency.digraph.maven.plugin.digraph.PropertyElement;
import net.kemitix.dependency.digraph.maven.plugin.digraph.Subgraph;
import net.kemitix.node.Node;

public abstract class AbstractDotFileFormat
implements DotFileFormat {
    private final Node<PackageData> base;
    private final NodePathGenerator nodePathGenerator;
    private final NodePackageDataComparator nodePackageDataComparator = new NodePackageDataComparator();
    private Map<Node<PackageData>, GraphElement> graphElements = new HashMap<Node<PackageData>, GraphElement>();

    public AbstractDotFileFormat(Node<PackageData> base, NodePathGenerator nodePathGenerator) {
        this.base = base;
        this.nodePathGenerator = nodePathGenerator;
    }

    protected String getClusterId(Node<PackageData> node) {
        return this.getPath(node, "_");
    }

    protected String getPath(Node<PackageData> headNode, String delimiter) {
        return this.nodePathGenerator.getPath(headNode, this.getBase(), delimiter);
    }

    protected Digraph createDigraph() {
        Digraph digraph = new Digraph();
        digraph.add(new PropertyElement("compound", "true"));
        NodeProperties nodeProperties = new NodeProperties();
        nodeProperties.add(new PropertyElement("shape", "box"));
        digraph.add(nodeProperties);
        return digraph;
    }

    @Override
    public String renderReport() {
        Digraph digraph = this.createDigraph();
        this.getNodeInjector().injectNodes(digraph, this.base);
        this.getUsageInjector().injectUsages(digraph, this.base);
        return this.render(digraph);
    }

    protected GraphUsageInjector getUsageInjector() {
        return (container, node) -> node.getChildren().stream().sorted(this.nodePackageDataComparator).forEach(this.injectUsagesByChildren(container));
    }

    private Consumer<Node<PackageData>> injectUsagesByChildren(ElementContainer container) {
        return childNode -> {
            childNode.getData().ifPresent(data -> data.getUses().stream().filter(n -> n.isDescendantOf(this.getBase())).sorted(this.nodePackageDataComparator).map(usedNode -> this.createEdgeElement((Node<PackageData>)childNode, (Node<PackageData>)usedNode)).forEach(container::add));
            this.getUsageInjector().injectUsages(container, (Node<PackageData>)childNode);
        };
    }

    EdgeEndpoint findEdgeEndpoint(Node<PackageData> node) {
        if (node.getChildren().isEmpty()) {
            return this.findNodeElement(node);
        }
        return this.findSubgraph(node);
    }

    NodeElement createNodeElement(Node<PackageData> packageDataNode) {
        return new NodeElement(packageDataNode, this.getNodeId(packageDataNode), NodeHelper.getRequiredData(packageDataNode).getName());
    }

    EdgeElement createEdgeElement(Node<PackageData> tail, Node<PackageData> head) {
        return new EdgeElement(this.findEdgeEndpoint(tail), this.findEdgeEndpoint(head));
    }

    protected NodeElement findNodeElement(Node<PackageData> node) {
        if (!this.graphElements.containsKey(node)) {
            this.graphElements.put(node, this.createNodeElement(node));
        }
        return (NodeElement)this.graphElements.get(node);
    }

    Subgraph findSubgraph(Node<PackageData> node) {
        if (!this.graphElements.containsKey(node)) {
            this.graphElements.put(node, this.createSubgraph(node));
        }
        return (Subgraph)this.graphElements.get(node);
    }

    private Subgraph createSubgraph(Node<PackageData> node) {
        return new Subgraph(node, this.getClusterId(node), NodeHelper.getRequiredData(node).getName());
    }

    protected GraphNodeInjector getNodeInjector() {
        return new GraphNodeInjector(){

            @Override
            public void injectNodes(ElementContainer container, Node<PackageData> node) {
                Set children = node.getChildren();
                if (children.isEmpty()) {
                    container.add(AbstractDotFileFormat.this.findNodeElement(node));
                } else {
                    Subgraph subgraph = AbstractDotFileFormat.this.findSubgraph(node);
                    children.stream().sorted(AbstractDotFileFormat.this.nodePackageDataComparator).forEach(c -> this.injectNodes(subgraph, (Node<PackageData>)c));
                    container.add(subgraph);
                }
            }
        };
    }

    protected String getNodeId(Node<PackageData> node) {
        return this.getPath(node, ".");
    }

    String render(GraphElement graphElement) {
        if (graphElement instanceof Digraph) {
            return this.render((Digraph)graphElement);
        }
        if (graphElement instanceof Subgraph) {
            return this.render((Subgraph)graphElement);
        }
        if (graphElement instanceof NodeProperties) {
            return this.render((NodeProperties)graphElement);
        }
        if (graphElement instanceof NodeElement) {
            return this.render((NodeElement)graphElement);
        }
        if (graphElement instanceof EdgeElement) {
            return this.render((EdgeElement)graphElement);
        }
        if (graphElement instanceof PropertyElement) {
            return this.render((PropertyElement)graphElement);
        }
        return "(graph-element)";
    }

    String render(Digraph digraph) {
        return "digraph{\n" + this.renderElements(digraph.getElements()) + "}\n";
    }

    abstract String render(Subgraph var1);

    String render(NodeProperties nodeProperties) {
        return "node[" + this.renderProperties(nodeProperties.getProperties()) + "]";
    }

    String render(NodeElement nodeElement) {
        String label;
        String id = nodeElement.getId();
        if (id.equals(label = nodeElement.getLabel())) {
            return this.quoted(id);
        }
        return this.quoted(id) + "[label=" + this.quoted(label) + "]";
    }

    abstract String render(EdgeElement var1);

    String render(PropertyElement propertyElement) {
        return propertyElement.getName() + "=" + this.quoted(propertyElement.getValue());
    }

    String renderElements(Collection<GraphElement> elements) {
        return elements.stream().map(this::render).collect(Collectors.joining("\n"));
    }

    String renderProperties(Set<PropertyElement> properties) {
        return properties.stream().map(this::render).collect(Collectors.joining(";\n"));
    }

    protected String quoted(String text) {
        return "\"" + text + "\"";
    }

    protected Node<PackageData> getBase() {
        return this.base;
    }

    @FunctionalInterface
    protected static interface GraphUsageInjector {
        public void injectUsages(ElementContainer var1, Node<PackageData> var2);
    }

    @FunctionalInterface
    protected static interface GraphNodeInjector {
        public void injectNodes(ElementContainer var1, Node<PackageData> var2);
    }
}

