/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.dependency.digraph.maven.plugin;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import net.kemitix.dependency.digraph.maven.plugin.DependencyData;
import net.kemitix.dependency.digraph.maven.plugin.DigraphService;
import net.kemitix.dependency.digraph.maven.plugin.DotFileFormatFactory;
import net.kemitix.dependency.digraph.maven.plugin.FileLoader;
import net.kemitix.dependency.digraph.maven.plugin.ReportGenerator;
import net.kemitix.dependency.digraph.maven.plugin.ReportWriter;
import net.kemitix.dependency.digraph.maven.plugin.SourceDirectoryProvider;
import net.kemitix.dependency.digraph.maven.plugin.SourceFileAnalyser;
import net.kemitix.dependency.digraph.maven.plugin.SourceFileProvider;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;

class DefaultDigraphService
implements DigraphService {
    private static final String REPORT_FILE = "target/digraph.dot";
    private final SourceDirectoryProvider directoryProvider;
    private final SourceFileProvider fileProvider;
    private final FileLoader fileLoader;
    private final SourceFileAnalyser fileAnalyser;
    private final DependencyData dependencyData;
    private final ReportGenerator reportGenerator;
    private final ReportWriter reportWriter;
    private final DotFileFormatFactory dotFileFormatFactory;

    @Inject
    DefaultDigraphService(SourceDirectoryProvider directoryProvider, SourceFileProvider fileProvider, FileLoader fileLoader, SourceFileAnalyser fileAnalyser, DependencyData dependencyData, ReportGenerator reportGenerator, ReportWriter reportWriter, DotFileFormatFactory dotFileFormatFactory) {
        this.directoryProvider = directoryProvider;
        this.fileProvider = fileProvider;
        this.fileLoader = fileLoader;
        this.fileAnalyser = fileAnalyser;
        this.dependencyData = dependencyData;
        this.reportGenerator = reportGenerator;
        this.reportWriter = reportWriter;
        this.dotFileFormatFactory = dotFileFormatFactory;
    }

    @Override
    public void execute(AbstractMojo mojo, List<MavenProject> projects, boolean includeTests, String basePackage, String format, boolean debug) {
        this.dependencyData.setBasePackage(basePackage);
        this.fileProvider.process(this.directoryProvider.getDirectories(projects, includeTests)).stream().map(this.fileLoader::asInputStream).forEach(this.fileAnalyser::analyse);
        if (debug) {
            this.dependencyData.debugLog(mojo.getLog());
        }
        try {
            this.reportWriter.write(this.reportGenerator.generate(this.dotFileFormatFactory.create(format, this.dependencyData.getBaseNode())), REPORT_FILE);
        }
        catch (IOException ex) {
            mojo.getLog().error((CharSequence)ex.getMessage());
        }
    }
}

