/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.dependency.digraph.maven.plugin;

import java.util.Arrays;
import lombok.NonNull;
import net.kemitix.dependency.digraph.maven.plugin.PackageTreeBuilder;
import net.kemitix.node.Node;
import net.kemitix.node.NodeException;
import net.kemitix.node.NodeItem;

class DefaultPackageTreeBuilder
implements PackageTreeBuilder {
    private String basePackage;
    private Node<String> tree;

    DefaultPackageTreeBuilder() {
    }

    @Override
    public void init(@NonNull String thePackage) {
        if (thePackage == null) {
            throw new NullPointerException("thePackage");
        }
        this.basePackage = thePackage;
        this.tree = new NodeItem((Object)thePackage);
    }

    @Override
    public void addPackages(String ... thePackages) {
        Arrays.asList(thePackages).forEach(this::addPackage);
    }

    private void addPackage(@NonNull String thePackage) {
        if (thePackage == null) {
            throw new NullPointerException("thePackage");
        }
        this.verifyWithinBasePackage(thePackage);
        this.tree.createDescendantLine(Arrays.asList(this.getRelativePackage(thePackage).split("\\.")));
    }

    private void verifyWithinBasePackage(String thePackage) {
        if (!thePackage.equals(this.basePackage) && !thePackage.startsWith(this.basePackage + ".")) {
            throw new NodeException("Package not within base package: " + thePackage);
        }
    }

    private String getRelativePackage(String thePackage) {
        if (!thePackage.endsWith(this.basePackage)) {
            return thePackage.substring(this.basePackage.length() + 1);
        }
        return ".";
    }

    @Override
    public Node<String> getTree() {
        return this.tree;
    }
}

