/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.dependency.digraph.maven.plugin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.kemitix.dependency.digraph.maven.plugin.SourceDirectoryProvider;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;

class DefaultSourceDirectoryProvider
implements SourceDirectoryProvider {
    DefaultSourceDirectoryProvider() {
    }

    @Override
    public List<String> getDirectories(List<MavenProject> projects, boolean includeTests) {
        ArrayList<String> directories = new ArrayList<String>();
        projects.forEach(project -> this.addProject((List<String>)directories, (MavenProject)project, includeTests));
        return directories;
    }

    private void addProject(List<String> directories, MavenProject project, boolean includeTests) {
        Build build = project.getBuild();
        this.addDirectoryIfExists(directories, build.getSourceDirectory());
        if (includeTests) {
            this.addDirectoryIfExists(directories, build.getTestSourceDirectory());
        }
    }

    private void addDirectoryIfExists(List<String> directories, String directory) {
        if (null != directory && Files.isDirectory(Paths.get(directory, new String[0]), new LinkOption[0])) {
            directories.add(directory);
        }
    }
}

