/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.dependency.digraph.maven.plugin;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.kemitix.dependency.digraph.maven.plugin.DependencyData;
import net.kemitix.dependency.digraph.maven.plugin.DigraphMojo;
import net.kemitix.dependency.digraph.maven.plugin.SourceFileAnalyser;

class DefaultSourceFileAnalyser
implements SourceFileAnalyser {
    private static final Pattern METHOD_IMPORT = Pattern.compile("^(?<package>.+)\\.(?<class>.+)\\.(?<method>.+)");
    private static final Pattern CLASS_IMPORT = Pattern.compile("^(?<package>.+)\\.(?<class>.+)");
    private final DigraphMojo mojo;
    private final DependencyData dependencyData;

    @Inject
    DefaultSourceFileAnalyser(DigraphMojo mojo, DependencyData dependencyData) {
        this.mojo = mojo;
        this.dependencyData = dependencyData;
    }

    @Override
    public void analyse(InputStream inputStream) {
        try {
            CompilationUnit cu = JavaParser.parse((InputStream)inputStream);
            PackageDeclaration aPackage = cu.getPackage();
            if (aPackage != null) {
                String packageName = aPackage.getName().toString();
                cu.getImports().forEach(id -> {
                    String name = id.getName().toString();
                    Matcher m = id.isStatic() && !id.isAsterisk() ? METHOD_IMPORT.matcher(name) : CLASS_IMPORT.matcher(name);
                    if (m.find()) {
                        this.dependencyData.addDependency(packageName, m.group("package"));
                    }
                });
            }
        }
        catch (ParseException ex) {
            this.mojo.getLog().error((CharSequence)("Error parsing file " + inputStream), (Throwable)ex);
        }
    }
}

