/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.dependency.digraph.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import net.kemitix.dependency.digraph.maven.plugin.DigraphMojo;
import net.kemitix.dependency.digraph.maven.plugin.SourceFileProvider;
import net.kemitix.dependency.digraph.maven.plugin.SourceFileVisitor;

class DefaultSourceFileProvider
implements SourceFileProvider {
    private final SourceFileVisitor fileVisitor;
    private final DigraphMojo mojo;

    @Inject
    DefaultSourceFileProvider(SourceFileVisitor fileVisitor, DigraphMojo mojo) {
        this.fileVisitor = fileVisitor;
        this.mojo = mojo;
    }

    @Override
    public List<File> process(List<String> directories) {
        directories.forEach(dir -> {
            try {
                Path start = new File((String)dir).getAbsoluteFile().toPath();
                Files.walkFileTree(start, this.fileVisitor);
            }
            catch (IOException ex) {
                this.mojo.getLog().error((Throwable)ex);
            }
        });
        return this.fileVisitor.getJavaFiles();
    }
}

