/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.dependency.digraph.maven.plugin;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import lombok.NonNull;
import net.kemitix.dependency.digraph.maven.plugin.DigraphModule;
import net.kemitix.dependency.digraph.maven.plugin.DigraphService;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="digraph", aggregator=true)
public class DigraphMojo
extends AbstractMojo {
    private final Injector injector = Guice.createInjector((Module[])new Module[]{new DigraphModule(), new AbstractModule(){

        protected void configure() {
            this.bind(DigraphMojo.class).toInstance((Object)DigraphMojo.this);
        }
    }});
    private final DigraphService digraphService = (DigraphService)this.injector.getInstance(DigraphService.class);
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> projects;
    @Parameter(name="includeTests", defaultValue="false")
    private boolean includeTests;
    @NonNull
    @Parameter(name="basePackage", required=true)
    private String basePackage;
    @Parameter(name="debug", defaultValue="true")
    private boolean debug;
    @Parameter(name="format", defaultValue="nested")
    private String format;

    public void execute() {
        this.digraphService.execute(this, this.projects, this.includeTests, this.basePackage, this.format, this.debug);
    }

    public void setProjects(List<MavenProject> projects) {
        this.projects = projects;
    }

    public void setBasePackage(@NonNull String basePackage) {
        if (basePackage == null) {
            throw new NullPointerException("basePackage");
        }
        this.basePackage = basePackage;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

