/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.dependency.digraph.maven.plugin;

import java.util.ArrayList;
import java.util.stream.Collectors;
import net.kemitix.dependency.digraph.maven.plugin.AbstractDotFileFormat;
import net.kemitix.dependency.digraph.maven.plugin.NodePathGenerator;
import net.kemitix.dependency.digraph.maven.plugin.PackageData;
import net.kemitix.dependency.digraph.maven.plugin.digraph.EdgeElement;
import net.kemitix.dependency.digraph.maven.plugin.digraph.Subgraph;
import net.kemitix.node.Node;

class DotFileFormatNested
extends AbstractDotFileFormat {
    DotFileFormatNested(Node<PackageData> base, NodePathGenerator nodePathGenerator) {
        super(base, nodePathGenerator);
    }

    @Override
    String render(Subgraph subgraph) {
        String label = this.quoted(subgraph.getLabel());
        String id = this.quoted(subgraph.getId());
        return String.format("subgraph %s{%nlabel=%s%n%s[label=\"\",style=\"invis\",width=0]%n%s%n}", this.quoted("cluster" + subgraph.getId()), label, id, this.renderElements(subgraph.getElements()));
    }

    @Override
    String render(EdgeElement edgeElement) {
        ArrayList<String> attributes = new ArrayList<String>();
        Node<PackageData> tailNode = edgeElement.getTail().getPackageDataNode();
        Node<PackageData> headNode = edgeElement.getHead().getPackageDataNode();
        if (tailNode.getChildren().size() > 0 && !headNode.isDescendantOf(tailNode)) {
            attributes.add(String.format("ltail=\"cluster%s\"", this.getClusterId(tailNode)));
        }
        if (headNode.getChildren().size() > 0 && !tailNode.isDescendantOf(headNode)) {
            attributes.add(String.format("lhead=\"cluster%s\"", this.getClusterId(headNode)));
        }
        String attributeTag = "";
        if (attributes.size() > 0) {
            attributeTag = String.format("[%s]", attributes.stream().collect(Collectors.joining(",")));
        }
        return String.format("%s->%s%s", this.quoted(this.getNodeId(tailNode)), this.quoted(this.getNodeId(headNode)), attributeTag);
    }
}

