/*
 * Decompiled with CFR 0.152.
 */
package net.kemitix.dependency.digraph.maven.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.kemitix.dependency.digraph.maven.plugin.DependencyData;
import net.kemitix.dependency.digraph.maven.plugin.PackageData;
import net.kemitix.node.Node;
import net.kemitix.node.NodeItem;
import org.apache.maven.plugin.logging.Log;

class NodeTreeDependencyData
implements DependencyData {
    private final Node<PackageData> root = new NodeItem((Object)new PackageData("[root]"));
    private Node<PackageData> baseNode;

    NodeTreeDependencyData() {
    }

    @Override
    public void addDependency(String user, String imported) {
        List<PackageData> userLine = this.createPackageLineList(user);
        this.root.createDescendantLine(userLine);
        List<PackageData> importedLine = this.createPackageLineList(imported);
        this.root.createDescendantLine(importedLine);
        this.root.findInPath(importedLine).ifPresent(i -> this.root.findInPath(userLine).ifPresent(u -> u.getData().ifPresent(upd -> upd.getUses().add((Node<PackageData>)i))));
    }

    @Override
    public void setBasePackage(String basePackage) {
        List<PackageData> baseLine = this.createPackageLineList(basePackage);
        this.root.createDescendantLine(baseLine);
        this.root.findInPath(baseLine).ifPresent(base -> {
            this.baseNode = base;
        });
    }

    @Override
    public void debugLog(Log log) {
        this.debugLogNode(log, this.baseNode, 0);
    }

    private List<PackageData> createPackageLineList(String userPackage) {
        ArrayList<PackageData> line = new ArrayList<PackageData>();
        Arrays.asList(userPackage.split("\\.")).forEach(n -> line.add(new PackageData((String)n)));
        return line;
    }

    private void debugLogNode(Log log, Node<PackageData> node, int depth) {
        String padding = IntStream.range(0, depth * 2).mapToObj(x -> " ").collect(Collectors.joining());
        node.getData().map(PackageData::getName).map(name -> padding + name).ifPresent(arg_0 -> ((Log)log).info(arg_0));
        node.getChildren().forEach(t -> this.debugLogNode(log, (Node<PackageData>)t, depth + 1));
    }

    @Override
    public Node<PackageData> getBaseNode() {
        return this.baseNode;
    }
}

