/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.core.dao.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.leadware.persistence.tools.api.dao.constants.DAOMode;
import net.leadware.persistence.tools.api.dao.constants.DAOValidatorEvaluationTime;
import net.leadware.persistence.tools.api.dao.constants.OrderType;
import net.leadware.persistence.tools.api.exceptions.JPersistenceToolsException;
import net.leadware.persistence.tools.api.utils.restrictions.Predicate;
import net.leadware.persistence.tools.api.validator.base.IDAOValidator;
import net.leadware.persistence.tools.api.validator.jsr303ext.engine.JSR303ValidatorEngine;
import net.leadware.persistence.tools.core.dao.JPAGenericDAO;
import net.leadware.persistence.tools.core.dao.utils.DAOValidatorHelper;

public abstract class JPAGenericDAORulesBasedImpl<T>
implements JPAGenericDAO<T> {
    protected Class<T> entityClass = this.getManagedEntityClass();
    protected final String ROOT_ALIAS = "ENTITY_CLASS__";
    protected boolean validateIntegrityConstraintOnSave = true;
    protected boolean validateIntegrityConstraintOnUpdate = true;
    protected boolean preValidateReferentialConstraintOnSave = true;
    protected boolean postValidateReferentialConstraintOnSave = false;
    protected boolean preValidateReferentialConstraintOnUpdate = true;
    protected boolean postValidateReferentialConstraintOnUpdate = false;
    protected boolean preValidateReferentialConstraintOnDelete = true;
    protected boolean postValidateReferentialConstraintOnDelete = false;

    @Override
    public void setValidateIntegrityConstraintOnSave(boolean validateIntegrityConstraintOnSave) {
        this.validateIntegrityConstraintOnSave = validateIntegrityConstraintOnSave;
    }

    @Override
    public void setValidateIntegrityConstraintOnUpdate(boolean validateIntegrityConstraintOnUpdate) {
        this.validateIntegrityConstraintOnUpdate = validateIntegrityConstraintOnUpdate;
    }

    @Override
    public void setPreValidateReferentialConstraintOnSave(boolean preValidateReferentialConstraintOnSave) {
        this.preValidateReferentialConstraintOnSave = preValidateReferentialConstraintOnSave;
    }

    @Override
    public void setPostValidateReferentialConstraintOnSave(boolean postValidateReferentialConstraintOnSave) {
        this.postValidateReferentialConstraintOnSave = postValidateReferentialConstraintOnSave;
    }

    @Override
    public void setPreValidateReferentialConstraintOnUpdate(boolean preValidateReferentialConstraintOnUpdate) {
        this.preValidateReferentialConstraintOnUpdate = preValidateReferentialConstraintOnUpdate;
    }

    @Override
    public void setPostValidateReferentialConstraintOnUpdate(boolean postValidateReferentialConstraintOnUpdate) {
        this.postValidateReferentialConstraintOnUpdate = postValidateReferentialConstraintOnUpdate;
    }

    @Override
    public void setPreValidateReferentialConstraintOnDelete(boolean preValidateReferentialConstraintOnDelete) {
        this.preValidateReferentialConstraintOnDelete = preValidateReferentialConstraintOnDelete;
    }

    @Override
    public void setPostValidateReferentialConstraintOnDelete(boolean postValidateReferentialConstraintOnDelete) {
        this.postValidateReferentialConstraintOnDelete = postValidateReferentialConstraintOnDelete;
    }

    @Override
    public void delete(Object entityID) {
        this.delete(entityID, this.preValidateReferentialConstraintOnDelete, this.postValidateReferentialConstraintOnDelete);
    }

    @Override
    public void delete(Object entityID, boolean preValidateReferentialConstraint, boolean postValidateReferentialConstraint) {
        if (entityID == null) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.delete.id.null");
        }
        Object entity = null;
        try {
            entity = this.getEntityManager().find(this.entityClass, entityID);
        }
        catch (EntityNotFoundException e) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.delete.entitynotexist", (Throwable)e);
        }
        if (preValidateReferentialConstraint) {
            this.validateEntityReferentialConstraint(entity, DAOMode.DELETE, DAOValidatorEvaluationTime.PRE_CONDITION);
        }
        try {
            this.getEntityManager().remove(entity);
        }
        catch (Exception e) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.delete.error", (Throwable)e);
        }
        if (postValidateReferentialConstraint) {
            this.validateEntityReferentialConstraint(entity, DAOMode.DELETE, DAOValidatorEvaluationTime.POST_CONDITION);
        }
    }

    @Override
    public void clean() {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        criteriaQuery.select((Selection)root);
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        List entities = query.getResultList();
        for (Object entity : entities) {
            this.getEntityManager().remove(entity);
        }
    }

    @Override
    public T save(T entity) {
        return this.save(entity, this.validateIntegrityConstraintOnSave, this.preValidateReferentialConstraintOnSave, this.postValidateReferentialConstraintOnSave);
    }

    @Override
    public T save(T entity, boolean validateIntegrityConstraint, boolean preValidateReferentialConstraint, boolean postValidateReferentialConstraint) {
        if (entity == null) {
            throw new JPersistenceToolsException("NullEntityException.message");
        }
        if (validateIntegrityConstraint) {
            this.validateEntityIntegrityConstraint(entity, DAOMode.SAVE, DAOValidatorEvaluationTime.PRE_CONDITION);
        }
        if (preValidateReferentialConstraint) {
            this.validateEntityReferentialConstraint(entity, DAOMode.SAVE, DAOValidatorEvaluationTime.PRE_CONDITION);
        }
        try {
            this.getEntityManager().persist(entity);
        }
        catch (Exception e) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.save.error", (Throwable)e);
        }
        if (postValidateReferentialConstraint) {
            this.validateEntityReferentialConstraint(entity, DAOMode.SAVE, DAOValidatorEvaluationTime.POST_CONDITION);
        }
        return entity;
    }

    @Override
    public T update(Object id, T entity) {
        return this.update(id, entity, this.validateIntegrityConstraintOnUpdate, this.preValidateReferentialConstraintOnUpdate, this.postValidateReferentialConstraintOnUpdate);
    }

    @Override
    public T update(Object id, T entity, boolean validateIntegrityConstraint, boolean preValidateReferentialConstraint, boolean postValidateReferentialConstraint) {
        if (id == null) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.update.entityid.null");
        }
        if (entity == null) {
            throw new JPersistenceToolsException("NullEntityException.message");
        }
        if (validateIntegrityConstraint) {
            this.validateEntityIntegrityConstraint(entity, DAOMode.UPDATE, DAOValidatorEvaluationTime.PRE_CONDITION);
        }
        if (preValidateReferentialConstraint) {
            this.validateEntityReferentialConstraint(entity, DAOMode.UPDATE, DAOValidatorEvaluationTime.PRE_CONDITION);
        }
        Object result = null;
        Object oldEntity = null;
        try {
            oldEntity = this.getEntityManager().find(this.entityClass, id);
        }
        catch (EntityNotFoundException e) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.update.entity.notfound");
        }
        catch (Exception e) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.update.entity.error.loading.old.entity", (Throwable)e);
        }
        if (oldEntity == null) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.update.entity.notfound");
        }
        try {
            result = this.getEntityManager().merge(entity);
        }
        catch (OptimisticLockException e) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.update.optimisticklockexception", (Throwable)e);
        }
        catch (Exception e) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.update.error", (Throwable)e);
        }
        if (postValidateReferentialConstraint) {
            this.validateEntityReferentialConstraint(entity, DAOMode.UPDATE, DAOValidatorEvaluationTime.POST_CONDITION);
        }
        return (T)result;
    }

    @Override
    public T findByPrimaryKey(String entityIDName, Object entityID, Set<String> properties) {
        if (entityIDName == null || entityIDName.trim().length() == 0) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.findbyprimarykey.idname.null");
        }
        if (entityID == null) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.findbyprimarykey.id.null");
        }
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        criteriaQuery.select((Selection)root);
        ParameterExpression idParameter = criteriaBuilder.parameter(Object.class, entityIDName);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get(entityIDName.trim()), (Expression)idParameter));
        this.addProperties(root, criteriaQuery, properties);
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        query.setParameter(entityIDName, entityID);
        try {
            return (T)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.findbyprimarykey.entityidname.invalid");
        }
    }

    @Override
    public T findByUniqueProperty(String propertyName, Object propertyValue, Set<String> properties) {
        if (propertyName == null || propertyName.trim().length() == 0) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.findbyuniqueproperty.propertyname.null");
        }
        if (propertyValue == null) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.findbyuniqueproperty.propertyvalue.null");
        }
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        criteriaQuery.select((Selection)root);
        ParameterExpression propertyParameter = criteriaBuilder.parameter(Object.class, propertyName);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)root.get(propertyName.trim()), (Expression)propertyParameter));
        this.addProperties(root, criteriaQuery, properties);
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        query.setParameter(propertyName, propertyValue);
        try {
            return (T)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.findbyuniqueproperty.entitypropertyname.notunique");
        }
    }

    @Override
    public long count(List<Predicate> predicates) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(this.entityClass);
        root.alias("ENTITY_CLASS__");
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        this.addPredicates(criteriaBuilder, root, criteriaQuery, predicates);
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        return (Long)query.getSingleResult();
    }

    @Override
    public synchronized List<T> filter(List<Predicate> predicates, Map<String, OrderType> orders, Set<String> properties, int firstResult, int maxResult) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        root.alias("ROOT");
        criteriaQuery.select((Selection)root);
        this.addPredicates(criteriaBuilder, root, criteriaQuery, predicates);
        this.addOrders(criteriaBuilder, root, criteriaQuery, orders);
        this.addProperties(root, criteriaQuery, properties);
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        if (firstResult < 0) {
            query.setFirstResult(0);
        } else {
            query.setFirstResult(firstResult);
        }
        if (maxResult > 0) {
            query.setMaxResults(maxResult);
        }
        List results = query.getResultList();
        return results;
    }

    @Override
    public <Q> List<Q> executeCriteria(CriteriaQuery<Q> criteriaQuery, Map<String, Object> parameters) {
        if (criteriaQuery == null) {
            throw new JPersistenceToolsException("jpagenericdaorulesbased.executeCriteria.query.null");
        }
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        this.addQueryParameters((Query)query, parameters);
        return query.getResultList();
    }

    protected void addQueryParameters(Query query, Map<String, Object> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
    }

    protected void addOrders(CriteriaBuilder criteriaBuilder, Root<T> root, CriteriaQuery<T> criteriaQuery, Map<String, OrderType> orders) {
        if (orders == null || orders.size() == 0) {
            return;
        }
        ArrayList<Order> lOrders = new ArrayList<Order>();
        for (String property : orders.keySet()) {
            if (property == null || property.trim().length() == 0) continue;
            Path<?> path = this.buildPropertyPathForAnyType(root, property.trim());
            OrderType type = orders.get(property);
            if (type == null) continue;
            if (type.equals((Object)OrderType.ASC)) {
                lOrders.add(criteriaBuilder.asc(path));
                continue;
            }
            lOrders.add(criteriaBuilder.desc(path));
        }
        criteriaQuery.orderBy(lOrders);
    }

    protected void addPredicates(CriteriaBuilder criteriaBuilder, Root<T> root, CriteriaQuery<?> criteriaQuery, List<Predicate> predicates) {
        ArrayList<javax.persistence.criteria.Predicate> jpaPredicates = new ArrayList<javax.persistence.criteria.Predicate>();
        for (Predicate predicate : predicates) {
            jpaPredicates.add(predicate.generateJPAPredicate(null, root));
        }
        criteriaQuery.where((Expression)criteriaBuilder.and(jpaPredicates.toArray(new javax.persistence.criteria.Predicate[0])));
    }

    private void addProperties(Root<T> root, Set<String> properties) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        for (String property : properties) {
            if (property != null && property.trim().length() != 0) continue;
        }
    }

    protected void addProperties(Root<T> root, CriteriaQuery<T> query, Set<String> properties) {
        this.addProperties(root, properties);
        query.distinct(true);
    }

    protected void validateEntityIntegrityConstraint(Object entity, DAOMode mode, DAOValidatorEvaluationTime validationTime) {
        JSR303ValidatorEngine.getDefaultInstance().validate(entity);
    }

    protected void validateEntityReferentialConstraint(Object entity, DAOMode mode, DAOValidatorEvaluationTime validationTime) {
        List<Annotation> daoAnnotations = DAOValidatorHelper.loadDAOValidatorAnnotations(entity);
        if (daoAnnotations == null || daoAnnotations.size() == 0) {
            return;
        }
        for (Annotation daoAnnotation : daoAnnotations) {
            Class<? extends IDAOValidator<? extends Annotation>> validatorClass = DAOValidatorHelper.getValidationLogicClass(daoAnnotation);
            IDAOValidator<? extends Annotation> validator = null;
            try {
                validator = validatorClass.newInstance();
                validator.initialize(daoAnnotation, this.getEntityManager(), mode, validationTime);
            }
            catch (Throwable e) {
                throw new JPersistenceToolsException("ValidatorInstanciationException.message", e);
            }
            validator.processValidation(entity);
        }
    }

    private Path<?> buildPropertyPathForAnyType(Root<T> root, String stringPath) {
        if (root == null) {
            return null;
        }
        if (stringPath == null || stringPath.trim().length() == 0) {
            return null;
        }
        Path path = null;
        String[] hierarchicalPaths = stringPath.trim().split("\\:");
        path = root.get(hierarchicalPaths[0]);
        if (hierarchicalPaths.length > 1) {
            for (int i = 1; i < hierarchicalPaths.length; ++i) {
                String unitPath = hierarchicalPaths[i];
                if (unitPath == null || unitPath.trim().length() == 0) continue;
                path = path.get(unitPath.trim());
            }
        }
        return path;
    }
}

