/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.persistence.tools.validator;

import java.util.List;
import javax.persistence.Query;
import net.leadware.persistence.tools.api.dao.constants.DAOMode;
import net.leadware.persistence.tools.api.dao.constants.DAOValidatorEvaluationTime;
import net.leadware.persistence.tools.api.dao.constants.ValidatorExpressionType;
import net.leadware.persistence.tools.api.exceptions.DAOValidationException;
import net.leadware.persistence.tools.api.validator.annotations.SizeDAOValidator;
import net.leadware.persistence.tools.validator.base.AbstractExpressionBasedDAOValidatorRule;

public class SizeDAOValidatorRule
extends AbstractExpressionBasedDAOValidatorRule {
    public void processValidation(Object entity) {
        if (!this.isProcessable()) {
            return;
        }
        ValidatorExpressionType type = this.getType();
        if (type == null) {
            type = ValidatorExpressionType.JPQL;
        }
        if (type.equals((Object)ValidatorExpressionType.HQL) || type.equals((Object)ValidatorExpressionType.JPQL) || type.equals((Object)ValidatorExpressionType.EJBQL)) {
            Query query = this.buildQuery(entity);
            List result = query.getResultList();
            long size = 0L;
            long min = ((SizeDAOValidator)this.annotation).min();
            long max = ((SizeDAOValidator)this.annotation).max();
            if (result != null && result.size() > 0) {
                size = result.size();
            }
            if (min > size || max < size) {
                throw new DAOValidationException(this.getMessage(), this.getMessageParameters(entity));
            }
        }
    }

    @Override
    protected String getExpression() {
        SizeDAOValidator castedAnnotation = (SizeDAOValidator)this.annotation;
        return castedAnnotation.expr();
    }

    @Override
    protected ValidatorExpressionType getType() {
        SizeDAOValidator castedAnnotation = (SizeDAOValidator)this.annotation;
        return castedAnnotation.type();
    }

    @Override
    protected String getMessage() {
        SizeDAOValidator castedAnnotation = (SizeDAOValidator)this.annotation;
        return castedAnnotation.message();
    }

    @Override
    protected DAOValidatorEvaluationTime[] getAnnotationEvaluationTime() {
        SizeDAOValidator castedAnnotation = (SizeDAOValidator)this.annotation;
        return castedAnnotation.evaluationTime();
    }

    @Override
    protected DAOMode[] getAnnotationMode() {
        SizeDAOValidator castedAnnotation = (SizeDAOValidator)this.annotation;
        return castedAnnotation.mode();
    }

    @Override
    protected String[] getMessageParametersExpressions() {
        SizeDAOValidator castedAnnotation = (SizeDAOValidator)this.annotation;
        return castedAnnotation.parameters();
    }
}

