/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import net.leadware.kafka.embedded.KafkaSimulator;
import net.leadware.kafka.embedded.model.Topic;
import net.leadware.kafka.embedded.utils.KafkaSimulatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(description="Service Rest de gestion des topics", produces="application/json", consumes="application/json")
@ConditionalOnClass(value={KafkaSimulator.class, KafkaSimulatorFactory.class})
@ConditionalOnProperty(prefix="embedded.kafka.simulator", name={"enabled"}, havingValue="true", matchIfMissing=false)
@RestController
@RequestMapping(path={"/kafka/simulator/api/1.0/topics"}, produces={"application/json"})
@Validated
public class TopicController {
    private static final Logger log = LoggerFactory.getLogger(TopicController.class);
    @Autowired
    private KafkaSimulator kafkaSimulator;

    @ApiOperation(value="Op\u00e9ration de cr\u00e9ation d'un topic")
    @PutMapping(path={"/{topicName}"})
    @ResponseStatus(code=HttpStatus.CREATED)
    public void createTopicByName(@ApiParam(name="topicName", required=true, value="Nom du topic \u00e0 cr\u00e9er") @PathVariable(value="topicName") @NotEmpty(message="Le param\u00e8tre 'topicName' doit \u00eatre renseign\u00e9") @NotEmpty(message="Le param\u00e8tre 'topicName' doit \u00eatre renseign\u00e9") String topicName) {
        log.debug("Cr\u00e9ation du topic : [{}]", (Object)topicName);
        this.kafkaSimulator.createTopics(topicName);
    }

    @ApiOperation(value="Op\u00e9ration de listage des topics en fonction de leur \u00e9tat de visibilit\u00e9")
    @ApiResponse(message="Liste des topics trouv\u00e9s", code=200)
    @GetMapping(path={"/{internal}"})
    @ResponseBody
    public List<Topic> listTopic(@ApiParam(name="internal", required=true, value="Topic interne ?") @PathVariable(name="internal") @NotNull(message="Le param\u00e8tre 'internal' doit \u00eatre renseign\u00e9") @NotNull(message="Le param\u00e8tre 'internal' doit \u00eatre renseign\u00e9") Boolean internal) {
        log.debug("Listage des topics [Interne = {}]", (Object)internal);
        return this.kafkaSimulator.listTopics(internal);
    }

    @ApiOperation(value="Op\u00e9ration de suppression d'un topic \u00e0 partir de son nom")
    @DeleteMapping(path={"/{topicName}"})
    @ResponseStatus(code=HttpStatus.NO_CONTENT)
    public void deleteTopic(@ApiParam(name="topicName", required=true, value="Nom du topic \u00e0 supprimer") @PathVariable(value="topicName") @NotEmpty(message="Le param\u00e8tre 'topicName' doit \u00eatre renseign\u00e9") @NotEmpty(message="Le param\u00e8tre 'topicName' doit \u00eatre renseign\u00e9") String topicName) {
        log.debug("Suppression du topic [{}]", (Object)topicName);
        this.kafkaSimulator.deleteTopics(topicName);
    }
}

