/*
 * Decompiled with CFR 0.152.
 */
package net.leadware.kafka.embedded.tools;

import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.SocketUtils;

public class SimulatorUtils {
    private static final Logger log = LoggerFactory.getLogger(SimulatorUtils.class);
    public static final int SIMULATOR_GENERATED_MIN_PORT = 1024;

    public static int findAvailablePortExcept(Integer ... excludes) {
        log.debug("Recherche d'un port libre non compris dans la liste [{}]", excludes == null ? "EMPTY" : Arrays.asList(excludes));
        if (excludes == null || excludes.length == 0) {
            return SocketUtils.findAvailableTcpPort((int)1024);
        }
        int generatedPortMinValue = Arrays.stream(excludes).sorted().mapToInt(p -> p).max().getAsInt() + 1;
        if (generatedPortMinValue < 1024) {
            generatedPortMinValue = 1024;
        }
        return SocketUtils.findAvailableTcpPort((int)generatedPortMinValue);
    }

    public static int findAvailablePortExcept(Collection<Integer> excludes) {
        log.debug("Recherche d'un port libre non compris dans la collection [{}]", excludes);
        if (excludes == null || excludes.isEmpty()) {
            return SimulatorUtils.findAvailablePortExcept((Integer[])null);
        }
        Integer[] arraysExcludes = (Integer[])excludes.stream().toArray(Integer[]::new);
        return SimulatorUtils.findAvailablePortExcept(arraysExcludes);
    }
}

