/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.apiclient.auth;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import net.leanix.dropkit.apiclient.ApiException;
import net.leanix.dropkit.apiclient.Pair;
import net.leanix.dropkit.apiclient.auth.OAuth;
import net.leanix.dropkit.apiclient.auth.responses.AccessTokenResponse;
import org.glassfish.jersey.internal.util.Base64;

public class ClientCredentialRefreshingOAuth
extends OAuth {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private boolean accessTokenSetManually = false;
    Client jerseyClient;
    URI tokenUrl;
    AccessTokenResponse accessTokenResponse;
    private String clientId;
    private String clientSecret;

    public void setClientCredentials(String clientId, String clientSecret, URI tokenUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenUrl = tokenUrl;
    }

    public void setClient(Client jerseyClient) {
        this.jerseyClient = jerseyClient;
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.accessTokenSetManually = accessToken != null;
        this.accessTokenResponse = null;
        super.setAccessToken(accessToken);
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams) throws ApiException {
        if (!this.accessTokenSetManually && this.tokenUrl != null && (this.accessTokenResponse == null || this.accessTokenResponse.isExpired())) {
            this.fetchToken();
            super.setAccessToken(this.accessTokenResponse.getAccessToken());
        }
        super.applyToParams(queryParams, headerParams);
    }

    private void fetchToken() throws ApiException {
        String basicAuthorizationHeader = this.buildBasicAuthorizationHeader();
        try {
            this.accessTokenResponse = (AccessTokenResponse)this.jerseyClient.target(this.tokenUrl).queryParam("grant_type", new Object[]{"client_credentials"}).request().accept(new String[]{"application/json"}).header("Content-Type", (Object)"application/x-www-form-urlencoded").header("Authorization", (Object)basicAuthorizationHeader).post(null, AccessTokenResponse.class);
        }
        catch (RuntimeException ex) {
            throw new ApiException("Failed to retrieve a new oauth token from " + this.tokenUrl, (Throwable)ex, 0, null);
        }
    }

    private String buildBasicAuthorizationHeader() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(this.clientId).append(':').append(this.clientSecret);
        String userAndPw = sb.toString();
        sb.setLength(0);
        sb.append("Basic ").append(Base64.encodeAsString((byte[])userAndPw.getBytes(UTF8)));
        return sb.toString();
    }
}

