/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.metrics.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.leanix.metrics.api.models.Field;
import net.leanix.metrics.api.models.Tag;

public class Point {
    private String measurement = null;
    private String workspaceId = null;
    private Date time = null;
    private List<Tag> tags = new ArrayList<Tag>();
    private List<Field> fields = new ArrayList<Field>();

    public Point measurement(String measurement) {
        this.measurement = measurement;
        return this;
    }

    @ApiModelProperty(example="null", value="A name for the measurement")
    @JsonProperty(value="measurement")
    public String getMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public Point workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @ApiModelProperty(example="null", value="A UUID string to relate the point to a workspace or \"shared\" if the shared database should be used.")
    @JsonProperty(value="workspaceId")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public Point time(Date time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Point tags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    @ApiModelProperty(example="null", value="List of tags")
    @JsonProperty(value="tags")
    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Point fields(List<Field> fields) {
        this.fields = fields;
        return this;
    }

    @ApiModelProperty(example="null", value="List of fields")
    @JsonProperty(value="fields")
    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        return Objects.equals(this.measurement, point.measurement) && Objects.equals(this.workspaceId, point.workspaceId) && Objects.equals(this.time, point.time) && Objects.equals(this.tags, point.tags) && Objects.equals(this.fields, point.fields);
    }

    public int hashCode() {
        return Objects.hash(this.measurement, this.workspaceId, this.time, this.tags, this.fields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Point {\n");
        sb.append("    measurement: ").append(this.toIndentedString(this.measurement)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

