/*
* The MIT License (MIT)	 
*
* Copyright (c) 2014 LeanIX GmbH
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
* the Software, and to permit persons to whom the Software is furnished to do so,
* subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
* COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
* IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package net.leanix.synclog.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.io.*;
import java.util.Date;
public class Synchronization
{
	private String id = null;
	private Date createdAt = null;
	private Date finishedAt = null;
	private String workspaceId = null;
	private String workspaceName = null;
	private String targetWorkspaceId = null;
	private String targetWorkspaceName = null;
	private String userId = null;
	private String topic = null;
	private String scope = null;
	private String direction = null;
	private String status = null;
	private String progress = null;
	private Integer totalCount = null;
	private Integer processedCount = null;
	private Integer errorCount = null;
	private Integer actionCount = null;
	private String message = null;
	@JsonProperty("id")
	public String getId()
	{
		return id;
	}
	
	@JsonProperty("id")
	public void setId(String id)
	{
		this.id = id;
	}

	@JsonProperty("createdAt")
	public Date getCreatedAt()
	{
		return createdAt;
	}
	
	@JsonProperty("createdAt")
	public void setCreatedAt(Date createdAt)
	{
		this.createdAt = createdAt;
	}

	@JsonProperty("finishedAt")
	public Date getFinishedAt()
	{
		return finishedAt;
	}
	
	@JsonProperty("finishedAt")
	public void setFinishedAt(Date finishedAt)
	{
		this.finishedAt = finishedAt;
	}

	@JsonProperty("workspaceId")
	public String getWorkspaceId()
	{
		return workspaceId;
	}
	
	@JsonProperty("workspaceId")
	public void setWorkspaceId(String workspaceId)
	{
		this.workspaceId = workspaceId;
	}

	@JsonProperty("workspaceName")
	public String getWorkspaceName()
	{
		return workspaceName;
	}
	
	@JsonProperty("workspaceName")
	public void setWorkspaceName(String workspaceName)
	{
		this.workspaceName = workspaceName;
	}

	@JsonProperty("targetWorkspaceId")
	public String getTargetWorkspaceId()
	{
		return targetWorkspaceId;
	}
	
	@JsonProperty("targetWorkspaceId")
	public void setTargetWorkspaceId(String targetWorkspaceId)
	{
		this.targetWorkspaceId = targetWorkspaceId;
	}

	@JsonProperty("targetWorkspaceName")
	public String getTargetWorkspaceName()
	{
		return targetWorkspaceName;
	}
	
	@JsonProperty("targetWorkspaceName")
	public void setTargetWorkspaceName(String targetWorkspaceName)
	{
		this.targetWorkspaceName = targetWorkspaceName;
	}

	@JsonProperty("userId")
	public String getUserId()
	{
		return userId;
	}
	
	@JsonProperty("userId")
	public void setUserId(String userId)
	{
		this.userId = userId;
	}

	@JsonProperty("topic")
	public String getTopic()
	{
		return topic;
	}
	
	@JsonProperty("topic")
	public void setTopic(String topic)
	{
		this.topic = topic;
	}

	@JsonProperty("scope")
	public String getScope()
	{
		return scope;
	}
	
	@JsonProperty("scope")
	public void setScope(String scope)
	{
		this.scope = scope;
	}

	@JsonProperty("direction")
	public String getDirection()
	{
		return direction;
	}
	
	@JsonProperty("direction")
	public void setDirection(String direction)
	{
		this.direction = direction;
	}

	@JsonProperty("status")
	public String getStatus()
	{
		return status;
	}
	
	@JsonProperty("status")
	public void setStatus(String status)
	{
		this.status = status;
	}

	@JsonProperty("progress")
	public String getProgress()
	{
		return progress;
	}
	
	@JsonProperty("progress")
	public void setProgress(String progress)
	{
		this.progress = progress;
	}

	@JsonProperty("totalCount")
	public Integer getTotalCount()
	{
		return totalCount;
	}
	
	@JsonProperty("totalCount")
	public void setTotalCount(Integer totalCount)
	{
		this.totalCount = totalCount;
	}

	@JsonProperty("processedCount")
	public Integer getProcessedCount()
	{
		return processedCount;
	}
	
	@JsonProperty("processedCount")
	public void setProcessedCount(Integer processedCount)
	{
		this.processedCount = processedCount;
	}

	@JsonProperty("errorCount")
	public Integer getErrorCount()
	{
		return errorCount;
	}
	
	@JsonProperty("errorCount")
	public void setErrorCount(Integer errorCount)
	{
		this.errorCount = errorCount;
	}

	@JsonProperty("actionCount")
	public Integer getActionCount()
	{
		return actionCount;
	}
	
	@JsonProperty("actionCount")
	public void setActionCount(Integer actionCount)
	{
		this.actionCount = actionCount;
	}

	@JsonProperty("message")
	public String getMessage()
	{
		return message;
	}
	
	@JsonProperty("message")
	public void setMessage(String message)
	{
		this.message = message;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		sb.append("class Synchronization {\n");
		sb.append("  id: ").append(id).append("\n");
		sb.append("  createdAt: ").append(createdAt).append("\n");
		sb.append("  finishedAt: ").append(finishedAt).append("\n");
		sb.append("  workspaceId: ").append(workspaceId).append("\n");
		sb.append("  workspaceName: ").append(workspaceName).append("\n");
		sb.append("  targetWorkspaceId: ").append(targetWorkspaceId).append("\n");
		sb.append("  targetWorkspaceName: ").append(targetWorkspaceName).append("\n");
		sb.append("  userId: ").append(userId).append("\n");
		sb.append("  topic: ").append(topic).append("\n");
		sb.append("  scope: ").append(scope).append("\n");
		sb.append("  direction: ").append(direction).append("\n");
		sb.append("  status: ").append(status).append("\n");
		sb.append("  progress: ").append(progress).append("\n");
		sb.append("  totalCount: ").append(totalCount).append("\n");
		sb.append("  processedCount: ").append(processedCount).append("\n");
		sb.append("  errorCount: ").append(errorCount).append("\n");
		sb.append("  actionCount: ").append(actionCount).append("\n");
		sb.append("  message: ").append(message).append("\n");
		sb.append("}\n");
		return sb.toString();
	}

    /**
     * Setter for unknown properties.
     *
     * @param key
     * @param value
     */
    @JsonAnySetter
    public void handleUnknown(String key, Object value)
    {
    }
}

