/*
* The MIT License (MIT)	 
*
* Copyright (c) 2014 LeanIX GmbH
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
* the Software, and to permit persons to whom the Software is furnished to do so,
* subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
* COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
* IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package net.leanix.synclog.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.*;

import java.util.Date;
public class SyncItem implements Serializable
{
	private String id = null;
	private Date createdAt = null;
	private String status = null;
	private String action = null;
	private String sourceId = null;
	private String sourceName = null;
	private String sourceType = null;
	private String targetId = null;
	private String targetName = null;
	private String targetType = null;
	private String message = null;
	@JsonProperty("id")
	public String getId()
	{
		return id;
	}
	
	@JsonProperty("id")
	public void setId(String id)
	{
		this.id = id;
	}

	@JsonProperty("createdAt")
	public Date getCreatedAt()
	{
		return createdAt;
	}
	
	@JsonProperty("createdAt")
	public void setCreatedAt(Date createdAt)
	{
		this.createdAt = createdAt;
	}

	@JsonProperty("status")
	public String getStatus()
	{
		return status;
	}
	
	@JsonProperty("status")
	public void setStatus(String status)
	{
		this.status = status;
	}

	@JsonProperty("action")
	public String getAction()
	{
		return action;
	}
	
	@JsonProperty("action")
	public void setAction(String action)
	{
		this.action = action;
	}

	@JsonProperty("sourceId")
	public String getSourceId()
	{
		return sourceId;
	}
	
	@JsonProperty("sourceId")
	public void setSourceId(String sourceId)
	{
		this.sourceId = sourceId;
	}

	@JsonProperty("sourceName")
	public String getSourceName()
	{
		return sourceName;
	}
	
	@JsonProperty("sourceName")
	public void setSourceName(String sourceName)
	{
		this.sourceName = sourceName;
	}

	@JsonProperty("sourceType")
	public String getSourceType()
	{
		return sourceType;
	}
	
	@JsonProperty("sourceType")
	public void setSourceType(String sourceType)
	{
		this.sourceType = sourceType;
	}

	@JsonProperty("targetId")
	public String getTargetId()
	{
		return targetId;
	}
	
	@JsonProperty("targetId")
	public void setTargetId(String targetId)
	{
		this.targetId = targetId;
	}

	@JsonProperty("targetName")
	public String getTargetName()
	{
		return targetName;
	}
	
	@JsonProperty("targetName")
	public void setTargetName(String targetName)
	{
		this.targetName = targetName;
	}

	@JsonProperty("targetType")
	public String getTargetType()
	{
		return targetType;
	}
	
	@JsonProperty("targetType")
	public void setTargetType(String targetType)
	{
		this.targetType = targetType;
	}

	@JsonProperty("message")
	public String getMessage()
	{
		return message;
	}
	
	@JsonProperty("message")
	public void setMessage(String message)
	{
		this.message = message;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		sb.append("class SyncItem {\n");
		sb.append("  id: ").append(id).append("\n");
		sb.append("  createdAt: ").append(createdAt).append("\n");
		sb.append("  status: ").append(status).append("\n");
		sb.append("  action: ").append(action).append("\n");
		sb.append("  sourceId: ").append(sourceId).append("\n");
		sb.append("  sourceName: ").append(sourceName).append("\n");
		sb.append("  sourceType: ").append(sourceType).append("\n");
		sb.append("  targetId: ").append(targetId).append("\n");
		sb.append("  targetName: ").append(targetName).append("\n");
		sb.append("  targetType: ").append(targetType).append("\n");
		sb.append("  message: ").append(message).append("\n");
		sb.append("}\n");
		return sb.toString();
	}
}

