/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api;

import net.leanix.dropkit.apiclient.ApiException;
import net.leanix.webhooks.api.EventsApi;
import net.leanix.webhooks.api.models.Event;
import net.leanix.webhooks.api.models.EventBatch;
import net.leanix.webhooks.api.models.EventListResponse;
import net.leanix.webhooks.api.models.EventResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubmitter {
    private EventsApi eventsApi;
    private long backoffTime;
    private int maxRetries;
    private static final Logger LOG = LoggerFactory.getLogger(EventsApi.class);

    public EventSubmitter(EventsApi eventsApi, long backoffTime, int maxRetries) {
        this.eventsApi = eventsApi;
        this.backoffTime = backoffTime;
        this.maxRetries = maxRetries;
    }

    public EventsApi getEventsApi() {
        return this.eventsApi;
    }

    public void setEventsApi(EventsApi eventsApi) {
        this.eventsApi = eventsApi;
    }

    public EventResponse submitEvent(Event body) throws ApiException {
        return this.submitEvent(body, 1);
    }

    private EventResponse submitEvent(Event body, int attempt) throws ApiException {
        try {
            return this.eventsApi.createEvent(body);
        }
        catch (ApiException e) {
            this.retry(attempt, e);
            return this.submitEvent(body, ++attempt);
        }
    }

    public EventListResponse submitEventBatch(EventBatch batch) throws ApiException {
        return this.submitEventBatch(batch, 1);
    }

    private EventListResponse submitEventBatch(EventBatch batch, int attempt) throws ApiException {
        try {
            return this.eventsApi.createEventBatch(batch);
        }
        catch (ApiException e) {
            this.retry(attempt, e);
            return this.submitEventBatch(batch, ++attempt);
        }
    }

    private void retry(int attempt, ApiException e) throws ApiException {
        if (attempt == this.maxRetries) {
            throw e;
        }
        long backoff = this.backoffTime * (long)attempt;
        LOG.warn(String.format("Failed to send event to webhooks: %s\nRetrying in %d ms.", e, backoff));
        try {
            Thread.sleep(backoff);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

