/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.leanix.dropkit.apiclient.RawJsonDeserializer;

public class Event {
    @JsonProperty(value="id")
    private UUID id = null;
    @JsonProperty(value="createdAt")
    private OffsetDateTime createdAt = null;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="sourceName")
    private String sourceName = null;
    @JsonProperty(value="sourceId")
    private String sourceId = null;
    @JsonProperty(value="sourceUrl")
    private String sourceUrl = null;
    @JsonProperty(value="workspaceId")
    private UUID workspaceId = null;
    @JsonProperty(value="userId")
    private UUID userId = null;
    @JsonProperty(value="tags")
    private List<String> tags = null;
    @JsonProperty(value="payload")
    private String payload = null;
    @JsonProperty(value="sequenceInfo")
    private Long sequenceInfo = null;

    public Event id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Event createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The date at which the event was originally created.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Event type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Event sourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    @ApiModelProperty(value="The name of the source system, e.g. EAM or MTM.")
    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Event sourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    @ApiModelProperty(value="The id in the source system.")
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Event sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @ApiModelProperty(value="The url of the source system, e.g. https://app.leanix.net.")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public Event workspaceId(UUID workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @ApiModelProperty(value="An optional UUID if the event is related to a workspace.")
    public UUID getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(UUID workspaceId) {
        this.workspaceId = workspaceId;
    }

    public Event userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="An optional UUID if the event is related to a user.")
    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public Event tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Event addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="a list of tags describing the nature of this event, used to find subscriptions for this event")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonDeserialize(using=RawJsonDeserializer.class)
    public Event payload(String payload) {
        this.payload = payload;
        return this;
    }

    @JsonRawValue
    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public Event sequenceInfo(Long sequenceInfo) {
        this.sequenceInfo = sequenceInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public Long getSequenceInfo() {
        return this.sequenceInfo;
    }

    public void setSequenceInfo(Long sequenceInfo) {
        this.sequenceInfo = sequenceInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.id, event.id) && Objects.equals(this.createdAt, event.createdAt) && Objects.equals(this.type, event.type) && Objects.equals(this.sourceName, event.sourceName) && Objects.equals(this.sourceId, event.sourceId) && Objects.equals(this.sourceUrl, event.sourceUrl) && Objects.equals(this.workspaceId, event.workspaceId) && Objects.equals(this.userId, event.userId) && Objects.equals(this.tags, event.tags) && Objects.equals(this.payload, event.payload) && Objects.equals(this.sequenceInfo, event.sequenceInfo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.type, this.sourceName, this.sourceId, this.sourceUrl, this.workspaceId, this.userId, this.tags, this.payload, this.sequenceInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Event {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    sourceName: ").append(this.toIndentedString(this.sourceName)).append("\n");
        sb.append("    sourceId: ").append(this.toIndentedString(this.sourceId)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    sequenceInfo: ").append(this.toIndentedString(this.sequenceInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

