/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class Subscription {
    @JsonProperty(value="deliveryType")
    private DeliveryTypeEnum deliveryType = null;
    @JsonProperty(value="id")
    private UUID id = null;
    @JsonProperty(value="identifier")
    private String identifier = null;
    @JsonProperty(value="tagSets")
    private List<List<String>> tagSets = null;
    @JsonProperty(value="createdAt")
    private OffsetDateTime createdAt = null;
    @JsonProperty(value="workspaceId")
    private UUID workspaceId = null;
    @JsonProperty(value="userId")
    private UUID userId = null;
    @JsonProperty(value="targetUrl")
    private String targetUrl = null;
    @JsonProperty(value="targetMethod")
    private String targetMethod = null;
    @JsonProperty(value="authorizationHeader")
    private String authorizationHeader = null;
    @JsonProperty(value="callback")
    private String callback = null;
    @JsonProperty(value="lastDeliveryStatus")
    private Integer lastDeliveryStatus = null;
    @JsonProperty(value="ignoreError")
    private Boolean ignoreError = null;
    @JsonProperty(value="maxBatchSize")
    private Integer maxBatchSize = null;
    @JsonProperty(value="workspaceConstraint")
    private WorkspaceConstraintEnum workspaceConstraint = null;
    @JsonProperty(value="active")
    private Boolean active = null;
    @JsonProperty(value="errorCount")
    private Integer errorCount = null;
    @JsonProperty(value="firstTimeDeliveryFailed")
    private OffsetDateTime firstTimeDeliveryFailed = null;
    @JsonProperty(value="payloadMode")
    private PayloadModeEnum payloadMode = null;

    public Subscription deliveryType(DeliveryTypeEnum deliveryType) {
        this.deliveryType = deliveryType;
        return this;
    }

    @ApiModelProperty(value="")
    public DeliveryTypeEnum getDeliveryType() {
        return this.deliveryType;
    }

    public void setDeliveryType(DeliveryTypeEnum deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Subscription id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Subscription identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @ApiModelProperty(value="")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Subscription tagSets(List<List<String>> tagSets) {
        this.tagSets = tagSets;
        return this;
    }

    public Subscription addTagSetsItem(List<String> tagSetsItem) {
        if (this.tagSets == null) {
            this.tagSets = new ArrayList<List<String>>();
        }
        this.tagSets.add(tagSetsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<List<String>> getTagSets() {
        return this.tagSets;
    }

    public void setTagSets(List<List<String>> tagSets) {
        this.tagSets = tagSets;
    }

    public Subscription createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Subscription workspaceId(UUID workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @ApiModelProperty(value="")
    public UUID getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(UUID workspaceId) {
        this.workspaceId = workspaceId;
    }

    public Subscription userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="")
    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public Subscription targetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="Used and required when 'deliveryType' is 'PUSH'.")
    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public Subscription targetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
        return this;
    }

    @ApiModelProperty(required=true, value="Used when 'deliveryType' is 'PUSH'.")
    public String getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public Subscription authorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
        return this;
    }

    @ApiModelProperty(value="Used when 'deliveryType' is 'PUSH'.")
    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public Subscription callback(String callback) {
        this.callback = callback;
        return this;
    }

    @ApiModelProperty(value="Used when 'deliveryType' is 'PUSH'.")
    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public Subscription lastDeliveryStatus(Integer lastDeliveryStatus) {
        this.lastDeliveryStatus = lastDeliveryStatus;
        return this;
    }

    @ApiModelProperty(value="Used when 'deliveryType' is 'PUSH'.")
    public Integer getLastDeliveryStatus() {
        return this.lastDeliveryStatus;
    }

    public void setLastDeliveryStatus(Integer lastDeliveryStatus) {
        this.lastDeliveryStatus = lastDeliveryStatus;
    }

    public Subscription ignoreError(Boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    @ApiModelProperty(required=true, value="Don't re-send events that caused an error on PUSH. Shirks the at-least-once policy! No effect on PULL.")
    public Boolean getIgnoreError() {
        return this.ignoreError;
    }

    public void setIgnoreError(Boolean ignoreError) {
        this.ignoreError = ignoreError;
    }

    public Subscription maxBatchSize(Integer maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
        return this;
    }

    @ApiModelProperty(value="Used when 'deliveryType' is 'PULL'. The desired maximum size (in kiB) of the returned batch of events. Default is 512. This is an approximate number: Actual responses may be smaller, or bigger when there is one single event exceeding maxBatchSize.")
    public Integer getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(Integer maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public Subscription workspaceConstraint(WorkspaceConstraintEnum workspaceConstraint) {
        this.workspaceConstraint = workspaceConstraint;
        return this;
    }

    @ApiModelProperty(value="Specifies how the workspaceId is used on events:  WORKSPACE -> get events with specified workspaceId (workspaceId must not be null), NO_WORKSPACE -> get events that have no workspaceId (workspaceId must be null), ANY -> get all events regardless if a workspaceId is assigned or not on the event")
    public WorkspaceConstraintEnum getWorkspaceConstraint() {
        return this.workspaceConstraint;
    }

    public void setWorkspaceConstraint(WorkspaceConstraintEnum workspaceConstraint) {
        this.workspaceConstraint = workspaceConstraint;
    }

    public Subscription active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Subscription errorCount(Integer errorCount) {
        this.errorCount = errorCount;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(Integer errorCount) {
        this.errorCount = errorCount;
    }

    public Subscription firstTimeDeliveryFailed(OffsetDateTime firstTimeDeliveryFailed) {
        this.firstTimeDeliveryFailed = firstTimeDeliveryFailed;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getFirstTimeDeliveryFailed() {
        return this.firstTimeDeliveryFailed;
    }

    public void setFirstTimeDeliveryFailed(OffsetDateTime firstTimeDeliveryFailed) {
        this.firstTimeDeliveryFailed = firstTimeDeliveryFailed;
    }

    public Subscription payloadMode(PayloadModeEnum payloadMode) {
        this.payloadMode = payloadMode;
        return this;
    }

    @ApiModelProperty(value="Specifies the behavior of the payload property of a delivery for this subscription:  DEFAULT -> get only the payload property of the event (default behavior), WRAPPED_EVENT -> get the whole serialized event as the payload, NO_PAYLOAD -> get always an empty {} payload")
    public PayloadModeEnum getPayloadMode() {
        return this.payloadMode;
    }

    public void setPayloadMode(PayloadModeEnum payloadMode) {
        this.payloadMode = payloadMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription subscription = (Subscription)o;
        return Objects.equals((Object)this.deliveryType, (Object)subscription.deliveryType) && Objects.equals(this.id, subscription.id) && Objects.equals(this.identifier, subscription.identifier) && Objects.equals(this.tagSets, subscription.tagSets) && Objects.equals(this.createdAt, subscription.createdAt) && Objects.equals(this.workspaceId, subscription.workspaceId) && Objects.equals(this.userId, subscription.userId) && Objects.equals(this.targetUrl, subscription.targetUrl) && Objects.equals(this.targetMethod, subscription.targetMethod) && Objects.equals(this.authorizationHeader, subscription.authorizationHeader) && Objects.equals(this.callback, subscription.callback) && Objects.equals(this.lastDeliveryStatus, subscription.lastDeliveryStatus) && Objects.equals(this.ignoreError, subscription.ignoreError) && Objects.equals(this.maxBatchSize, subscription.maxBatchSize) && Objects.equals((Object)this.workspaceConstraint, (Object)subscription.workspaceConstraint) && Objects.equals(this.active, subscription.active) && Objects.equals(this.errorCount, subscription.errorCount) && Objects.equals(this.firstTimeDeliveryFailed, subscription.firstTimeDeliveryFailed) && Objects.equals((Object)this.payloadMode, (Object)subscription.payloadMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deliveryType, this.id, this.identifier, this.tagSets, this.createdAt, this.workspaceId, this.userId, this.targetUrl, this.targetMethod, this.authorizationHeader, this.callback, this.lastDeliveryStatus, this.ignoreError, this.maxBatchSize, this.workspaceConstraint, this.active, this.errorCount, this.firstTimeDeliveryFailed, this.payloadMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Subscription {\n");
        sb.append("    deliveryType: ").append(this.toIndentedString((Object)this.deliveryType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    tagSets: ").append(this.toIndentedString(this.tagSets)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    targetUrl: ").append(this.toIndentedString(this.targetUrl)).append("\n");
        sb.append("    targetMethod: ").append(this.toIndentedString(this.targetMethod)).append("\n");
        sb.append("    authorizationHeader: ").append(this.toIndentedString(this.authorizationHeader)).append("\n");
        sb.append("    callback: ").append(this.toIndentedString(this.callback)).append("\n");
        sb.append("    lastDeliveryStatus: ").append(this.toIndentedString(this.lastDeliveryStatus)).append("\n");
        sb.append("    ignoreError: ").append(this.toIndentedString(this.ignoreError)).append("\n");
        sb.append("    maxBatchSize: ").append(this.toIndentedString(this.maxBatchSize)).append("\n");
        sb.append("    workspaceConstraint: ").append(this.toIndentedString((Object)this.workspaceConstraint)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    errorCount: ").append(this.toIndentedString(this.errorCount)).append("\n");
        sb.append("    firstTimeDeliveryFailed: ").append(this.toIndentedString(this.firstTimeDeliveryFailed)).append("\n");
        sb.append("    payloadMode: ").append(this.toIndentedString((Object)this.payloadMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PayloadModeEnum {
        DEFAULT("DEFAULT"),
        WRAPPED_EVENT("WRAPPED_EVENT"),
        NO_PAYLOAD("NO_PAYLOAD");

        private String value;

        private PayloadModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayloadModeEnum fromValue(String text) {
            for (PayloadModeEnum b : PayloadModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum WorkspaceConstraintEnum {
        WORKSPACE("WORKSPACE"),
        NO_WORKSPACE("NO_WORKSPACE"),
        ANY("ANY");

        private String value;

        private WorkspaceConstraintEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WorkspaceConstraintEnum fromValue(String text) {
            for (WorkspaceConstraintEnum b : WorkspaceConstraintEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum DeliveryTypeEnum {
        PUSH("PUSH"),
        PULL("PULL");

        private String value;

        private DeliveryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeliveryTypeEnum fromValue(String text) {
            for (DeliveryTypeEnum b : DeliveryTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

