/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api;

import java.util.HashMap;
import net.leanix.dropkit.api.ApiClient;
import net.leanix.dropkit.api.ApiException;
import net.leanix.webhooks.api.models.DeliveryListResponse;
import net.leanix.webhooks.api.models.Subscription;
import net.leanix.webhooks.api.models.SubscriptionListResponse;
import net.leanix.webhooks.api.models.SubscriptionResponse;

public class SubscriptionsApi {
    private ApiClient apiClient;

    public SubscriptionsApi(ApiClient client) {
        this.apiClient = client;
    }

    public void setClient(ApiClient client) {
        this.apiClient = client;
    }

    public ApiClient getClient() {
        return this.apiClient;
    }

    public SubscriptionResponse deleteSubscription(String id) throws ApiException {
        String path = "/subscriptions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap queryParams = new HashMap();
        HashMap headerParams = new HashMap();
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiClient.invokeAPI(path, "DELETE", queryParams, null, headerParams);
            if (response != null) {
                return (SubscriptionResponse)ApiClient.deserialize((String)response, (String)"", SubscriptionResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SubscriptionResponse updateSubscription(String id, Subscription body) throws ApiException {
        String path = "/subscriptions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap queryParams = new HashMap();
        HashMap headerParams = new HashMap();
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiClient.invokeAPI(path, "PUT", queryParams, (Object)body, headerParams);
            if (response != null) {
                return (SubscriptionResponse)ApiClient.deserialize((String)response, (String)"", SubscriptionResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeliveryListResponse getSubscriptionDeliveries(String id) throws ApiException {
        String path = "/subscriptions/{id}/deliveries".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap queryParams = new HashMap();
        HashMap headerParams = new HashMap();
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiClient.invokeAPI(path, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (DeliveryListResponse)ApiClient.deserialize((String)response, (String)"", DeliveryListResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SubscriptionResponse createSubscription(Subscription body) throws ApiException {
        String path = "/subscriptions".replaceAll("\\{format\\}", "json");
        HashMap queryParams = new HashMap();
        HashMap headerParams = new HashMap();
        try {
            String response = this.apiClient.invokeAPI(path, "POST", queryParams, (Object)body, headerParams);
            if (response != null) {
                return (SubscriptionResponse)ApiClient.deserialize((String)response, (String)"", SubscriptionResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public SubscriptionListResponse getSubscriptions(String workspaceId, String eventId) throws ApiException {
        String path = "/subscriptions".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        if (!"null".equals(String.valueOf(workspaceId))) {
            queryParams.put("workspaceId", String.valueOf(workspaceId));
        }
        if (!"null".equals(String.valueOf(eventId))) {
            queryParams.put("eventId", String.valueOf(eventId));
        }
        try {
            String response = this.apiClient.invokeAPI(path, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (SubscriptionListResponse)ApiClient.deserialize((String)response, (String)"", SubscriptionListResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

