/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import net.leanix.dropkit.api.Client;
import net.leanix.dropkit.api.Payload;
import net.leanix.webhooks.api.models.Event;
import net.leanix.webhooks.api.models.Subscription;
import org.slf4j.Logger;

public class WebhooksClient {
    private final Logger logger;
    private final Client client;

    public WebhooksClient(Client client, Logger logger) {
        this.client = client;
        this.logger = logger;
    }

    public boolean createSubscription(Subscription subscription) {
        String url = "/subscriptions";
        WebResource resource = this.client.resource(url);
        try {
            ((WebResource.Builder)resource.type("application/json").accept(new String[]{"application/json"})).post((Object)subscription);
            return true;
        }
        catch (ClientHandlerException | UniformInterfaceException ex) {
            String serialized = "";
            ObjectMapper mapper = new ObjectMapper();
            try {
                serialized = mapper.writeValueAsString((Object)subscription);
            }
            catch (JsonProcessingException ex1) {
                this.logger.error(ex1.getMessage());
            }
            this.logger.error("Failed to create the subscription " + serialized, ex);
            return false;
        }
    }

    public boolean triggerEvent(String workspaceId, String eventId, Payload payload) {
        String url = "/events/" + eventId;
        WebResource resource = this.client.resource(url);
        Event trigger = new Event();
        trigger.setEventId(eventId);
        trigger.setWorkspaceId(workspaceId);
        trigger.setPayload(payload.toString());
        try {
            ((WebResource.Builder)resource.type("application/json").accept(new String[]{"application/json"})).post((Object)trigger);
            return true;
        }
        catch (ClientHandlerException | UniformInterfaceException ex) {
            String serialized = "";
            ObjectMapper mapper = new ObjectMapper();
            try {
                serialized = mapper.writeValueAsString((Object)payload);
            }
            catch (JsonProcessingException ex1) {
                this.logger.error(ex1.getMessage());
            }
            this.logger.error("Failed to trigger " + eventId + " with payload " + serialized, ex);
            return false;
        }
    }
}

