/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api;

import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import net.leanix.dropkit.api.ApiException;
import net.leanix.dropkit.api.Client;
import net.leanix.dropkit.api.Response;
import net.leanix.dropkit.api.ValidationException;
import net.leanix.webhooks.api.models.DeliveryListResponse;
import net.leanix.webhooks.api.models.Subscription;
import net.leanix.webhooks.api.models.SubscriptionListResponse;
import net.leanix.webhooks.api.models.SubscriptionResponse;

public class SubscriptionsApi {
    private Client apiClient;

    public SubscriptionsApi(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.apiClient = client;
    }

    public Client getClient() {
        return this.apiClient;
    }

    private static MultivaluedMap<String, String> buildmvm(Map<String, String> map) {
        MultivaluedMapImpl mvMap = new MultivaluedMapImpl();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            mvMap.add(entry.getKey(), entry.getValue());
        }
        return mvMap;
    }

    public SubscriptionListResponse getSubscriptions(String workspaceId, String identifier) throws ApiException {
        String path = "/subscriptions".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(workspaceId))) {
            queryParams.put("workspaceId", String.valueOf(workspaceId));
        }
        if (!"null".equals(String.valueOf(identifier))) {
            queryParams.put("identifier", String.valueOf(identifier));
        }
        HashMap headerParams = new HashMap();
        try {
            return (SubscriptionListResponse)this.apiClient.resource(path).queryParams(SubscriptionsApi.buildmvm(queryParams)).method("GET", SubscriptionListResponse.class);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }

    public SubscriptionResponse createSubscription(Subscription body) throws ApiException {
        String path = "/subscriptions".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        try {
            return (SubscriptionResponse)this.apiClient.resource(path).queryParams(SubscriptionsApi.buildmvm(queryParams)).type("application/json").method("POST", SubscriptionResponse.class, (Object)body);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }

    public SubscriptionResponse getSubscription(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/subscriptions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", id.toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        try {
            return (SubscriptionResponse)this.apiClient.resource(path).queryParams(SubscriptionsApi.buildmvm(queryParams)).method("GET", SubscriptionResponse.class);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }

    public SubscriptionResponse updateSubscription(String id, Subscription body) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/subscriptions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", id.toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        try {
            return (SubscriptionResponse)this.apiClient.resource(path).queryParams(SubscriptionsApi.buildmvm(queryParams)).type("application/json").method("PUT", SubscriptionResponse.class, (Object)body);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }

    public SubscriptionResponse deleteSubscription(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/subscriptions/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", id.toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        try {
            return (SubscriptionResponse)this.apiClient.resource(path).queryParams(SubscriptionsApi.buildmvm(queryParams)).method("DELETE", SubscriptionResponse.class);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }

    public DeliveryListResponse getSubscriptionDeliveries(String id, Integer page, Integer size, String sort) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/subscriptions/{id}/deliveries".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", id.toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(page))) {
            queryParams.put("page", String.valueOf(page));
        }
        if (!"null".equals(String.valueOf(size))) {
            queryParams.put("size", String.valueOf(size));
        }
        if (!"null".equals(String.valueOf(sort))) {
            queryParams.put("sort", String.valueOf(sort));
        }
        HashMap headerParams = new HashMap();
        try {
            return (DeliveryListResponse)this.apiClient.resource(path).queryParams(SubscriptionsApi.buildmvm(queryParams)).method("GET", DeliveryListResponse.class);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }
}

