/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.webhooks.api;

import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import net.leanix.dropkit.api.ApiException;
import net.leanix.dropkit.api.Client;
import net.leanix.dropkit.api.Response;
import net.leanix.dropkit.api.ValidationException;
import net.leanix.webhooks.api.models.SubscriptionListResponse;
import net.leanix.webhooks.api.models.Watcher;
import net.leanix.webhooks.api.models.WatcherListResponse;
import net.leanix.webhooks.api.models.WatcherResponse;

public class WatchersApi {
    private Client apiClient;

    public WatchersApi(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.apiClient = client;
    }

    public Client getClient() {
        return this.apiClient;
    }

    private static MultivaluedMap<String, String> buildmvm(Map<String, String> map) {
        MultivaluedMapImpl mvMap = new MultivaluedMapImpl();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            mvMap.add(entry.getKey(), entry.getValue());
        }
        return mvMap;
    }

    public WatcherResponse createWatcher(Watcher body) throws ApiException {
        String path = "/watchers".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        try {
            return (WatcherResponse)this.apiClient.resource(path).queryParams(WatchersApi.buildmvm(queryParams)).type("application/json").method("POST", WatcherResponse.class, (Object)body);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }

    public WatcherListResponse getWatchers() throws ApiException {
        String path = "/watchers".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        try {
            return (WatcherListResponse)this.apiClient.resource(path).queryParams(WatchersApi.buildmvm(queryParams)).method("GET", WatcherListResponse.class);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }

    public WatcherResponse updateWatcher(String id, Watcher body) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/watchers/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", id.toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        try {
            return (WatcherResponse)this.apiClient.resource(path).queryParams(WatchersApi.buildmvm(queryParams)).type("application/json").method("PUT", WatcherResponse.class, (Object)body);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }

    public WatcherResponse deleteWatcher(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/watchers/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", id.toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        try {
            return (WatcherResponse)this.apiClient.resource(path).queryParams(WatchersApi.buildmvm(queryParams)).method("DELETE", WatcherResponse.class);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }

    public SubscriptionListResponse getWatcherSubscription(String id) throws ApiException {
        if (id == null) {
            throw new ApiException(400, "missing required params");
        }
        String path = "/watchers/{id}/subscription".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", id.toString());
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap headerParams = new HashMap();
        try {
            return (SubscriptionListResponse)this.apiClient.resource(path).queryParams(WatchersApi.buildmvm(queryParams)).method("GET", SubscriptionListResponse.class);
        }
        catch (UniformInterfaceException ex) {
            if (ex.getResponse().getStatus() == 404) {
                return null;
            }
            if (ex.getResponse().getStatus() == 422) {
                throw new ValidationException((Response)ex.getResponse().getEntity(Response.class));
            }
            throw new ApiException(ex.getResponse().getStatus(), ex.getResponse().toString());
        }
    }
}

