/*
* The MIT License (MIT)	 
*
* Copyright (c) 2014 LeanIX GmbH
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
* the Software, and to permit persons to whom the Software is furnished to do so,
* subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
* COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
* IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package net.leanix.webhooks.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Set;

import java.util.Date;
public class Delivery implements Serializable
{
	private String id = null;
	private Date createdAt = null;
	private String requestHeaders = null;
	private String payload = null;
	private String targetUrl = null;
	private String targetMethod = null;
	private String basicAuth = null;
	private Boolean success = null;
	private Integer httpStatus = null;
	private String responseBody = null;
	private String responseHeaders = null;
	@JsonProperty("id")
	public String getId()
	{
		return id;
	}
	
	@JsonProperty("id")
	public void setId(String id)
	{
		this.id = id;
	}

	@JsonProperty("createdAt")
	public Date getCreatedAt()
	{
		return createdAt;
	}
	
	@JsonProperty("createdAt")
	public void setCreatedAt(Date createdAt)
	{
		this.createdAt = createdAt;
	}

	@JsonProperty("requestHeaders")
	public String getRequestHeaders()
	{
		return requestHeaders;
	}
	
	@JsonProperty("requestHeaders")
	public void setRequestHeaders(String requestHeaders)
	{
		this.requestHeaders = requestHeaders;
	}

	@JsonProperty("payload")
	public String getPayload()
	{
		return payload;
	}
	
	@JsonProperty("payload")
	public void setPayload(String payload)
	{
		this.payload = payload;
	}

	@JsonProperty("targetUrl")
	public String getTargetUrl()
	{
		return targetUrl;
	}
	
	@JsonProperty("targetUrl")
	public void setTargetUrl(String targetUrl)
	{
		this.targetUrl = targetUrl;
	}

	@JsonProperty("targetMethod")
	public String getTargetMethod()
	{
		return targetMethod;
	}
	
	@JsonProperty("targetMethod")
	public void setTargetMethod(String targetMethod)
	{
		this.targetMethod = targetMethod;
	}

	@JsonProperty("basicAuth")
	public String getBasicAuth()
	{
		return basicAuth;
	}
	
	@JsonProperty("basicAuth")
	public void setBasicAuth(String basicAuth)
	{
		this.basicAuth = basicAuth;
	}

	@JsonProperty("success")
	public Boolean getSuccess()
	{
		return success;
	}
	
	@JsonProperty("success")
	public void setSuccess(Boolean success)
	{
		this.success = success;
	}

	@JsonProperty("httpStatus")
	public Integer getHttpStatus()
	{
		return httpStatus;
	}
	
	@JsonProperty("httpStatus")
	public void setHttpStatus(Integer httpStatus)
	{
		this.httpStatus = httpStatus;
	}

	@JsonProperty("responseBody")
	public String getResponseBody()
	{
		return responseBody;
	}
	
	@JsonProperty("responseBody")
	public void setResponseBody(String responseBody)
	{
		this.responseBody = responseBody;
	}

	@JsonProperty("responseHeaders")
	public String getResponseHeaders()
	{
		return responseHeaders;
	}
	
	@JsonProperty("responseHeaders")
	public void setResponseHeaders(String responseHeaders)
	{
		this.responseHeaders = responseHeaders;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		sb.append("class Delivery {\n");
		sb.append("  id: ").append(id).append("\n");
		sb.append("  createdAt: ").append(createdAt).append("\n");
		sb.append("  requestHeaders: ").append(requestHeaders).append("\n");
		sb.append("  payload: ").append(payload).append("\n");
		sb.append("  targetUrl: ").append(targetUrl).append("\n");
		sb.append("  targetMethod: ").append(targetMethod).append("\n");
		sb.append("  basicAuth: ").append(basicAuth).append("\n");
		sb.append("  success: ").append(success).append("\n");
		sb.append("  httpStatus: ").append(httpStatus).append("\n");
		sb.append("  responseBody: ").append(responseBody).append("\n");
		sb.append("  responseHeaders: ").append(responseHeaders).append("\n");
		sb.append("}\n");
		return sb.toString();
	}
}

