/*
* The MIT License (MIT)	 
*
* Copyright (c) 2014 LeanIX GmbH
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
* the Software, and to permit persons to whom the Software is furnished to do so,
* subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
* COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
* IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package net.leanix.webhooks.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Set;

public class Event implements Serializable
{
	/* An optional UUID string if the event is related to a workspace. */
	private String workspaceId = null;
	/* a list of tags describing the nature of this event, used to find subscriptions for this event */
	private Set<String> tags = null;
	private String payload = null;
	private String messageId = null;
	@JsonProperty("workspaceId")
	public String getWorkspaceId()
	{
		return workspaceId;
	}
	
	@JsonProperty("workspaceId")
	public void setWorkspaceId(String workspaceId)
	{
		this.workspaceId = workspaceId;
	}

	@JsonProperty("tags")
	public Set<String> getTags()
	{
		return tags;
	}
	
	@JsonProperty("tags")
	public void setTags(Set<String> tags)
	{
		this.tags = tags;
	}

	@JsonProperty("payload")
	public String getPayload()
	{
		return payload;
	}
	
	@JsonProperty("payload")
	public void setPayload(String payload)
	{
		this.payload = payload;
	}

	@JsonProperty("messageId")
	public String getMessageId()
	{
		return messageId;
	}
	
	@JsonProperty("messageId")
	public void setMessageId(String messageId)
	{
		this.messageId = messageId;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		sb.append("class Event {\n");
		sb.append("  workspaceId: ").append(workspaceId).append("\n");
		sb.append("  tags: ").append(tags).append("\n");
		sb.append("  payload: ").append(payload).append("\n");
		sb.append("  messageId: ").append(messageId).append("\n");
		sb.append("}\n");
		return sb.toString();
	}
}

