/*
* The MIT License (MIT)	 
*
* Copyright (c) 2014 LeanIX GmbH
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
* the Software, and to permit persons to whom the Software is furnished to do so,
* subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
* COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
* IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package net.leanix.webhooks.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Set;

import java.util.Date;
public class Subscription implements Serializable
{
	private String id = null;
	private String identifier = null;
	private String tagSets = null;
	private Date createdAt = null;
	private String workspaceId = null;
	private String userId = null;
	private String targetUrl = null;
	private String targetMethod = null;
	private String authorizationHeader = null;
	private Integer lastDeliveryStatus = null;
	@JsonProperty("id")
	public String getId()
	{
		return id;
	}
	
	@JsonProperty("id")
	public void setId(String id)
	{
		this.id = id;
	}

	@JsonProperty("identifier")
	public String getIdentifier()
	{
		return identifier;
	}
	
	@JsonProperty("identifier")
	public void setIdentifier(String identifier)
	{
		this.identifier = identifier;
	}

	@JsonProperty("tagSets")
	public String getTagSets()
	{
		return tagSets;
	}
	
	@JsonProperty("tagSets")
	public void setTagSets(String tagSets)
	{
		this.tagSets = tagSets;
	}

	@JsonProperty("createdAt")
	public Date getCreatedAt()
	{
		return createdAt;
	}
	
	@JsonProperty("createdAt")
	public void setCreatedAt(Date createdAt)
	{
		this.createdAt = createdAt;
	}

	@JsonProperty("workspaceId")
	public String getWorkspaceId()
	{
		return workspaceId;
	}
	
	@JsonProperty("workspaceId")
	public void setWorkspaceId(String workspaceId)
	{
		this.workspaceId = workspaceId;
	}

	@JsonProperty("userId")
	public String getUserId()
	{
		return userId;
	}
	
	@JsonProperty("userId")
	public void setUserId(String userId)
	{
		this.userId = userId;
	}

	@JsonProperty("targetUrl")
	public String getTargetUrl()
	{
		return targetUrl;
	}
	
	@JsonProperty("targetUrl")
	public void setTargetUrl(String targetUrl)
	{
		this.targetUrl = targetUrl;
	}

	@JsonProperty("targetMethod")
	public String getTargetMethod()
	{
		return targetMethod;
	}
	
	@JsonProperty("targetMethod")
	public void setTargetMethod(String targetMethod)
	{
		this.targetMethod = targetMethod;
	}

	@JsonProperty("authorizationHeader")
	public String getAuthorizationHeader()
	{
		return authorizationHeader;
	}
	
	@JsonProperty("authorizationHeader")
	public void setAuthorizationHeader(String authorizationHeader)
	{
		this.authorizationHeader = authorizationHeader;
	}

	@JsonProperty("lastDeliveryStatus")
	public Integer getLastDeliveryStatus()
	{
		return lastDeliveryStatus;
	}
	
	@JsonProperty("lastDeliveryStatus")
	public void setLastDeliveryStatus(Integer lastDeliveryStatus)
	{
		this.lastDeliveryStatus = lastDeliveryStatus;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		sb.append("class Subscription {\n");
		sb.append("  id: ").append(id).append("\n");
		sb.append("  identifier: ").append(identifier).append("\n");
		sb.append("  tagSets: ").append(tagSets).append("\n");
		sb.append("  createdAt: ").append(createdAt).append("\n");
		sb.append("  workspaceId: ").append(workspaceId).append("\n");
		sb.append("  userId: ").append(userId).append("\n");
		sb.append("  targetUrl: ").append(targetUrl).append("\n");
		sb.append("  targetMethod: ").append(targetMethod).append("\n");
		sb.append("  authorizationHeader: ").append(authorizationHeader).append("\n");
		sb.append("  lastDeliveryStatus: ").append(lastDeliveryStatus).append("\n");
		sb.append("}\n");
		return sb.toString();
	}
}

