/*
* The MIT License (MIT)	 
*
* Copyright (c) 2014 LeanIX GmbH
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
* the Software, and to permit persons to whom the Software is furnished to do so,
* subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
* COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
* IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

package net.leanix.webhooks.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Set;

import java.util.Date;
public class Watcher implements Serializable
{
	private String id = null;
	private String workspaceId = null;
	private String type = null;
	private Date lastRun = null;
	private Date lastUpdate = null;
	private String config = null;
	private String targetUrl = null;
	private String targetMethod = null;
	private String payload = null;
	private String name = null;
	@JsonProperty("id")
	public String getId()
	{
		return id;
	}
	
	@JsonProperty("id")
	public void setId(String id)
	{
		this.id = id;
	}

	@JsonProperty("workspaceId")
	public String getWorkspaceId()
	{
		return workspaceId;
	}
	
	@JsonProperty("workspaceId")
	public void setWorkspaceId(String workspaceId)
	{
		this.workspaceId = workspaceId;
	}

	@JsonProperty("type")
	public String getType()
	{
		return type;
	}
	
	@JsonProperty("type")
	public void setType(String type)
	{
		this.type = type;
	}

	@JsonProperty("lastRun")
	public Date getLastRun()
	{
		return lastRun;
	}
	
	@JsonProperty("lastRun")
	public void setLastRun(Date lastRun)
	{
		this.lastRun = lastRun;
	}

	@JsonProperty("lastUpdate")
	public Date getLastUpdate()
	{
		return lastUpdate;
	}
	
	@JsonProperty("lastUpdate")
	public void setLastUpdate(Date lastUpdate)
	{
		this.lastUpdate = lastUpdate;
	}

	@JsonProperty("config")
	public String getConfig()
	{
		return config;
	}
	
	@JsonProperty("config")
	public void setConfig(String config)
	{
		this.config = config;
	}

	@JsonProperty("targetUrl")
	public String getTargetUrl()
	{
		return targetUrl;
	}
	
	@JsonProperty("targetUrl")
	public void setTargetUrl(String targetUrl)
	{
		this.targetUrl = targetUrl;
	}

	@JsonProperty("targetMethod")
	public String getTargetMethod()
	{
		return targetMethod;
	}
	
	@JsonProperty("targetMethod")
	public void setTargetMethod(String targetMethod)
	{
		this.targetMethod = targetMethod;
	}

	@JsonProperty("payload")
	public String getPayload()
	{
		return payload;
	}
	
	@JsonProperty("payload")
	public void setPayload(String payload)
	{
		this.payload = payload;
	}

	@JsonProperty("name")
	public String getName()
	{
		return name;
	}
	
	@JsonProperty("name")
	public void setName(String name)
	{
		this.name = name;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		sb.append("class Watcher {\n");
		sb.append("  id: ").append(id).append("\n");
		sb.append("  workspaceId: ").append(workspaceId).append("\n");
		sb.append("  type: ").append(type).append("\n");
		sb.append("  lastRun: ").append(lastRun).append("\n");
		sb.append("  lastUpdate: ").append(lastUpdate).append("\n");
		sb.append("  config: ").append(config).append("\n");
		sb.append("  targetUrl: ").append(targetUrl).append("\n");
		sb.append("  targetMethod: ").append(targetMethod).append("\n");
		sb.append("  payload: ").append(payload).append("\n");
		sb.append("  name: ").append(name).append("\n");
		sb.append("}\n");
		return sb.toString();
	}
}

