package net.leanix.webhooks.api.models;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;






public class Subscription   {
  
  private String id = null;
  private String identifier = null;
  private Date createdAt = null;
  private String workspaceId = null;
  private String userId = null;
  private String targetUrl = null;
  private String targetMethod = null;
  private String authorizationHeader = null;
  private String callback = null;
  private Integer lastDeliveryStatus = null;
  private List<List<String>> tagSets = new ArrayList<List<String>>();

  
  /**
   **/
  public Subscription id(String id) {
    this.id = id;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("id")
  public String getId() {
    return id;
  }
  public void setId(String id) {
    this.id = id;
  }

  
  /**
   **/
  public Subscription identifier(String identifier) {
    this.identifier = identifier;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("identifier")
  public String getIdentifier() {
    return identifier;
  }
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }

  
  /**
   **/
  public Subscription createdAt(Date createdAt) {
    this.createdAt = createdAt;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "")
  @JsonProperty("createdAt")
  public Date getCreatedAt() {
    return createdAt;
  }
  public void setCreatedAt(Date createdAt) {
    this.createdAt = createdAt;
  }

  
  /**
   **/
  public Subscription workspaceId(String workspaceId) {
    this.workspaceId = workspaceId;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("workspaceId")
  public String getWorkspaceId() {
    return workspaceId;
  }
  public void setWorkspaceId(String workspaceId) {
    this.workspaceId = workspaceId;
  }

  
  /**
   **/
  public Subscription userId(String userId) {
    this.userId = userId;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("userId")
  public String getUserId() {
    return userId;
  }
  public void setUserId(String userId) {
    this.userId = userId;
  }

  
  /**
   **/
  public Subscription targetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("targetUrl")
  public String getTargetUrl() {
    return targetUrl;
  }
  public void setTargetUrl(String targetUrl) {
    this.targetUrl = targetUrl;
  }

  
  /**
   **/
  public Subscription targetMethod(String targetMethod) {
    this.targetMethod = targetMethod;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("targetMethod")
  public String getTargetMethod() {
    return targetMethod;
  }
  public void setTargetMethod(String targetMethod) {
    this.targetMethod = targetMethod;
  }

  
  /**
   **/
  public Subscription authorizationHeader(String authorizationHeader) {
    this.authorizationHeader = authorizationHeader;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("authorizationHeader")
  public String getAuthorizationHeader() {
    return authorizationHeader;
  }
  public void setAuthorizationHeader(String authorizationHeader) {
    this.authorizationHeader = authorizationHeader;
  }

  
  /**
   **/
  public Subscription callback(String callback) {
    this.callback = callback;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("callback")
  public String getCallback() {
    return callback;
  }
  public void setCallback(String callback) {
    this.callback = callback;
  }

  
  /**
   **/
  public Subscription lastDeliveryStatus(Integer lastDeliveryStatus) {
    this.lastDeliveryStatus = lastDeliveryStatus;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("lastDeliveryStatus")
  public Integer getLastDeliveryStatus() {
    return lastDeliveryStatus;
  }
  public void setLastDeliveryStatus(Integer lastDeliveryStatus) {
    this.lastDeliveryStatus = lastDeliveryStatus;
  }

  
  /**
   **/
  public Subscription tagSets(List<List<String>> tagSets) {
    this.tagSets = tagSets;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("tagSets")
  public List<List<String>> getTagSets() {
    return tagSets;
  }
  public void setTagSets(List<List<String>> tagSets) {
    this.tagSets = tagSets;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Subscription subscription = (Subscription) o;
    return Objects.equals(this.id, subscription.id) &&
        Objects.equals(this.identifier, subscription.identifier) &&
        Objects.equals(this.createdAt, subscription.createdAt) &&
        Objects.equals(this.workspaceId, subscription.workspaceId) &&
        Objects.equals(this.userId, subscription.userId) &&
        Objects.equals(this.targetUrl, subscription.targetUrl) &&
        Objects.equals(this.targetMethod, subscription.targetMethod) &&
        Objects.equals(this.authorizationHeader, subscription.authorizationHeader) &&
        Objects.equals(this.callback, subscription.callback) &&
        Objects.equals(this.lastDeliveryStatus, subscription.lastDeliveryStatus) &&
        Objects.equals(this.tagSets, subscription.tagSets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, identifier, createdAt, workspaceId, userId, targetUrl, targetMethod, authorizationHeader, callback, lastDeliveryStatus, tagSets);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Subscription {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    workspaceId: ").append(toIndentedString(workspaceId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    targetUrl: ").append(toIndentedString(targetUrl)).append("\n");
    sb.append("    targetMethod: ").append(toIndentedString(targetMethod)).append("\n");
    sb.append("    authorizationHeader: ").append(toIndentedString(authorizationHeader)).append("\n");
    sb.append("    callback: ").append(toIndentedString(callback)).append("\n");
    sb.append("    lastDeliveryStatus: ").append(toIndentedString(lastDeliveryStatus)).append("\n");
    sb.append("    tagSets: ").append(toIndentedString(tagSets)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

